
/* very simple app to set the tv frequency */

#include <sys/time.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <linux/fs.h>
#include <linux/videodev2.h>

int main(int argc,char **argv) {
  int vfd = 0;
  int arg = 1;
  struct v4l2_window win;
  char *devname = "/dev/video";

  if( argc != 6 ) {
        puts("Usage: preview_on x y width height key\n");
        puts("  x,y - upper left corner on desktop\n");
        puts("  width,height - size of preview window\n");
        puts("  key - currently unused\n");
        exit(1);
  }

  win.x = atoi(argv[1]);
  win.y = atoi(argv[2]);
  win.width = atoi(argv[3]);
  win.height = atoi(argv[4]);
  win.chromakey = atoi(argv[5]);
  win.clips = NULL;
  win.clipcount = 0;

  vfd = open(devname,O_RDWR|O_NONCAP);
  if (vfd <= 0) {
    fprintf(stderr,"sorry, no such device %s\n",devname);
    exit(1);
  }

  if (ioctl(vfd,VIDIOC_PREVIEW,&arg) < 0)
    perror("setting frequency"),exit(1);

  if (ioctl(vfd,VIDIOC_S_WIN,&win) < 0)
    perror("setting frequency"),exit(1);
  close(vfd);
  return 0;
}
