/*	For changing the capture dimensions on a V4L2 device.
 *	Originally written by Erik Walthinsen
 */



#include <sys/time.h>
#include <sys/types.h>
#include <asm/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/mman.h>
#include <errno.h>
#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/videodev2.h>

void print_settings(int fd) {
  struct v4l2_format fmt;
  int input = -1;
  struct v4l2_input inp;

  if (ioctl(fd,VIDIOC_G_FMT,&fmt) < 0)
    perror("getting video format"),exit(1);
  if (ioctl(fd,VIDIOC_G_INPUT,&input) < 0)
    perror("getting video input"),exit(1);
  inp.index = input;
  if (ioctl(fd,VIDIOC_ENUMINPUT,&inp) < 0)
    perror("getting video input"),exit(1);
  printf("%d x %d @ %d bpp from input %d (%s)\n",
	 fmt.width,fmt.height,fmt.depth,input,inp.name);
  printf("The inputs are:");
  for (input=0; ;++input)
  {
	inp.index = input;
	if (ioctl(fd,VIDIOC_ENUMINPUT,&inp) < 0)
		break;
	printf(" %d=%s",input,inp.name);
  }
  printf("\n");
  close(fd);
  exit(0);
}

int main(int argc,char **argv) {
  int vfd = 0;
  int arg;
  char curchar;
  int devicenext = 0;
  char *devname = "/dev/video";

  int width=0,height=0,bpp=0;
  int input=-1;
  int query = 1;

  struct v4l2_format fmt;

    for (arg=1;arg<argc;arg++) {
      if (argv[arg][0] == '-') {
        /* this is an option */
        curchar = argv[arg][1];
        switch (curchar) {
          case 'w': if (!width) width = atoi(argv[++arg]);break;
          case 'h': if (!height) height = atoi(argv[++arg]);break;
          case 'b': if (!bpp) bpp = atoi(argv[++arg]);break;
          case 'i': if (input==-1) input = atoi(argv[++arg]);break;
          default:
            fprintf(stderr,"unknown option %c\n",curchar);exit(1);
        }
	query = 0;
      } else {
        curchar = argv[arg][0];
        if ((curchar >= '0') && (curchar <= '9') && (!width) && (!devicenext)) {
          /* this might be a geometry */
          char *hptr, *bptr;
          int fieldlen;
          hptr = strchr(argv[arg],(int)'x');
          fieldlen = (long)hptr - (long)argv[arg];
          if ((!fieldlen) || (fieldlen > 5) || (!hptr)) continue;
          hptr[0] = 0;
          width = atoi(argv[arg]);
          hptr++;
          bptr = strchr(hptr,(int)'x');
          fieldlen = (long)hptr - (long)argv[arg];
          if ((!fieldlen) || (fieldlen > 5)) {
            width = 0;
            /* try this argument again, explicitly not as a geometry */
            arg--;devicenext = 1;
            continue;
          }
	  query = 0;
          if (bptr) bptr[0] = 0;
          height = atoi(hptr);
          if (bptr) {
            bptr++;
            bpp = atoi(bptr);
          }
        } else {
          devname = argv[arg];
        }
        devicenext = 0;
      }
    }

  vfd = open(devname,O_RDWR);
  if ((vfd > 0) && (argc <= 2)) print_settings(vfd);

  if (vfd <= 0) {
    fprintf(stderr,"sorry, no such device %s\n",devname);
    exit(1);
  }

  if (ioctl(vfd,VIDIOC_G_FMT,&fmt) < 0)
    perror("getting video format"),exit(1);
  if (width) fmt.width = width;
  if (height) fmt.height = height;
  if (bpp) fmt.depth = bpp;
  switch (bpp) {
    case 15: fmt.pixelformat = V4L2_PIX_FMT_RGB555;break;
    case 16: fmt.pixelformat = V4L2_PIX_FMT_RGB565;break;
    case 24: fmt.pixelformat = V4L2_PIX_FMT_BGR24;break;
    case 32: fmt.pixelformat = V4L2_PIX_FMT_BGR32;break;
  }
  if (ioctl(vfd,VIDIOC_S_FMT,&fmt) < 0)
    perror("setting video format"),exit(1);
  if (input != -1 && ioctl(vfd,VIDIOC_S_INPUT,input) < 0)
    perror("setting video input"),exit(1);

  close(vfd);
  return 0;
}
