/*
 * Video Capture Driver ( Video for Linux 1/2 )
 * for the Matrox Marvel G200 and Rainbow Runner-G series
 *
 * This module is an interface to the KS0127 video decoder chip.
 *
 * Copyright (C) 1999  Ryan Drake <stiletto@mediaone.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef KS0127_H
#define KS0127_H

/* control codes */
#define KS0127_RESET            _IOW('k',1,int)
#define KS0127_SET_INPUT        _IOW('k',2,int)
#define KS0127_SET_OUTPUT       _IOW('k',3,int)
#define KS0127_SET_STANDARD     _IOW('k',4,int)
#define KS0127_SET_BRIGHTNESS   _IOW('k',5,__u8)
#define KS0127_SET_CONTRAST     _IOW('k',6,__u8)
#define KS0127_SET_HUE          _IOW('k',7,__u8)
#define KS0127_SET_SATURATION   _IOW('k',8,__u8)
#define KS0127_SET_AGC_MODE     _IOW('k',9,int)
#define KS0127_SET_AGC          _IOW('k',10,__u8)
#define KS0127_SET_CHROMA_MODE  _IOW('k',11,int)
#define KS0127_SET_PIXCLK_MODE  _IOW('k',12,int)
#define KS0127_SET_GAMMA_MODE   _IOW('k',13,int)
#define KS0127_SET_UGAIN        _IOW('k',14,__u8)
#define KS0127_SET_VGAIN        _IOW('k',15,__u8)
#define KS0127_SET_INVALY       _IOW('k',16,__u8)
#define KS0127_SET_INVALU       _IOW('k',17,__u8)
#define KS0127_SET_INVALV       _IOW('k',18,__u8)
#define KS0127_SET_UNUSEY       _IOW('k',19,__u8)
#define KS0127_SET_UNUSEU       _IOW('k',20,__u8)
#define KS0127_SET_UNUSEV       _IOW('k',21,__u8)
#define KS0127_SET_VSALIGN_MODE _IOW('k',22,int)
#define KS0127_SET_OUTPUT_MODE  _IOW('k',23,int)
#define	KS0127_SET_WIDTH	_IOW('K',24,int)
#define	KS0127_SET_HEIGHT	_IOW('K',25,int)
#define KS0127_GET_STATUS       _IOR('k',50,__u8)

/* input channels */
#define KS_INPUT_COMPOSITE      0
#define KS_INPUT_SVIDEO         1
#define KS_INPUT_TUNER          2
#define KS_INPUT_YUV656_60HZ    3
#define KS_INPUT_YUV656_50HZ    4
#define KS_INPUT_COUNT          5

/* output channels */
#define KS_OUTPUT_YUV656E       0
#define KS_OUTPUT_EXV           1
#define KS_OUTPUT_RGB565	2
#define	KS_OUTPUT_RGB888	3

/* video standards */
#define KS_STD_NTSC             KS_STD_NTSC_M
#define KS_STD_PAL              KS_STD_PAL_N
#define KS_STD_NTSC_M           0
#define KS_STD_PAL_N            1
#define KS_STD_NTSC_N           2       /* 50 Hz NTSC */
#define KS_STD_PAL_M            3       /* 60 Hz PAL  */
#define KS_STD_SECAM            4

/* agc gain control modes */
#define KS_AGC_NORMAL           0
#define KS_AGC_MODE1            1
#define KS_AGC_MANUAL           2
#define KS_AGC_AUTO             3

/* chroma modes */
#define KS_CHROMA_AUTO          0
#define KS_CHROMA_ON            1
#define KS_CHROMA_OFF           2

/* pixel clock modes */
#define KS_PIXCLK_CCIR601       0
#define KS_PIXCLK_SQUARE        1

/* gamma modes */
#define KS_GAMMA_OFF            0
#define KS_GAMMA_Y              1
#define KS_GAMMA_UV             2
#define KS_GAMMA_YUV            3

/* vs alignment modes */
#define KS_VSALIGN0             0
#define KS_VSALIGN1             1

/* output modes */
#define KS_OUTPUT_NORMAL        0
#define KS_OUTPUT_HIZ           1
#define KS_OUTPUT_SYNC_HIZ      2
#define KS_OUTPUT_SYNC_CLK_HIZ  3

#if 0
#define KS_NTSC_COMP_LIVE_IN    1
#define KS_NTSC_YC_LIVE_IN      2
#define KS_NTSC_COMP_RECORD     3
#define KS_NTSC_YC_RECORD       4
#define KS_NTSC_PLAYBACK        5
#define KS_PAL_COMP_LIVE_IN     6
#define KS_PAL_YC_LIVE_IN       7
#define KS_PAL_COMP_RECORD      8
#define KS_PAL_YC_RECORD        9
#define KS_PAL_PLAYBACK         10
#define KS_SEC_COMP_LIVE_IN     11
#define KS_SEC_YC_LIVE_IN       12
#define KS_SEC_COMP_RECORD      13
#define KS_SEC_YC_RECORD        14
#endif

/* status bits */
#define KS_STATUS_COLOR_LOCK      0x09
#define KS_STATUS_COLOR_LOCK_NO   0x00
#define KS_STATUS_COLOR_LOCK_NTSC 0x01
#define KS_STATUS_COLOR_LOCK_PAL  0x09

#define KS_STATUS_TRACK           0x02
#define KS_STATUS_TRACK_INIT      0x00
#define KS_STATUS_TRACK_SS        0x02

#define KS_STATUS_COLOR_DET       0x04
#define KS_STATUS_COLOR_DET_NO    0x00
#define KS_STATUS_COLOR_DET_YES   0x04

#define KS_STATUS_FREQ            0x10
#define KS_STATUS_FREQ_50HZ       0x00
#define KS_STATUS_FREQ_60HZ       0x10

#define KS_STATUS_SYNC            0x20
#define KS_STATUS_SYNC_YES        0x00
#define KS_STATUS_SYNC_NO         0x20

#define KS_STATUS_REGION          0x40
#define KS_STATUS_REGION_VIDEO    0x00
#define KS_STATUS_REGION_VBI      0x40

#define KS_STATUS_CHIPID          0x80
#define KS_STATUS_CHIPID_KS0122   0x00
#define KS_STATUS_CHIPID_KS0127   0x80

#endif /* KS0127_H */
