/*
  File: obuffer.h
  
  Description:
  Output buffer for Audio
*/


#ifndef __obuffer_h__
#define __obuffer_h__


static const uint32 OBUFFERSIZE = 2 * 1152;	// max. 2 * 1152 samples per frame
static const uint32 MAXCHANNELS = 2;		// max. number of channels


// This file has been hacked with ifdefs to allow static linking of the 
// IRIX AL (Audio Library) functions (otherwise undefined references)!


// abstract base class for audio output classes:
class Obuffer {
 public:
  virtual ~Obuffer(void) {}		// dummy
  virtual void append (uint32 channel, int16 value) = 0;
	       // this function takes a 16 Bit PCM sample
  virtual void write_buffer (int fd) = 0;
	       // this function should write the samples to the filedescriptor
	       // or directly to the audio hardware
};


// audio output class for raw pcm output:
class ShortObuffer : public Obuffer {
 private:
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
 public:
  ShortObuffer(uint32 number_of_channels);
  ~ShortObuffer(void){}
  void	append(uint32 channel, int16 value);
  void	write_buffer(int fd);
};


#ifdef IRIX                  // a class for direct sound output on SGI machines:

class IrixObuffer : public Obuffer {
 private:
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
  ALport port;
 public:
  IrixObuffer(uint32 number_of_channels, Header* header);
  ~IrixObuffer();
  void append(uint32 channel, int16 value);
  void write_buffer(int dummy);
};

#endif	// IRIX


#if (defined(SOLARIS))      // a class for direct sound output on SPARC 5/10/20 machines (cs432/dbri)

class SparcObuffer : public Obuffer {
 private:
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
  static int audio_fd;

  static int open_audio_device(void);
  static void get_device_type(int fd, audio_device *);
 public:
  SparcObuffer(uint32 number_of_channels, Header *,
               bool use_speaker, bool use_headphone, bool use_line_out);
  ~SparcObuffer(void);
  void	append(uint32 channel, int16 value);
  void	write_buffer(int dummy);
  static bool class_suitable (void);
	// returnvalue == False: no 16-bit output possible (class unsuitable)
};
#endif	// SPARC

#if (defined(LINUX))      // a class for direct sound output on Linux machines

class LinuxObuffer : public Obuffer {
 private:
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
  static int audio_fd;

  static int open_audio_device(void);
 public:
  LinuxObuffer(uint32 number_of_channels, Header *);
  ~LinuxObuffer(void);
  void  append(uint32 channel, int16 value);
  void  write_buffer(int dummy);
  static bool class_suitable (void);
        // returnvalue == False: no 16-bit output possible (class unsuitable)
};
#endif  // LINUX

#endif // __obuffer_h__


