
#ifndef SUBBAND_LAYER_1_H
#define SUBBAND_LAYER_1_H


// class for layer I subbands in single channel mode:
class SubbandLayer1 : public Subband {
 protected:
  uint32 subbandnumber;
  uint32 samplenumber;
  uint32 allocation;
  uint32 scalefactor;
  uint32 samplelength;
  real	 sample;
  real	 factor, offset;
 public:
  SubbandLayer1(uint32 subbandnbr) : subbandnumber(subbandnbr), samplenumber(0) {}
  void read_allocation (AudioStream *, Header *, Crc16 *);
  void read_scalefactor (AudioStream *, Header *);
  bool read_sampledata (AudioStream *);
  bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *);
};


// class for layer I subbands in joint stereo mode:
class SubbandLayer1IntensityStereo : public SubbandLayer1 {
 protected:
  uint32 channel2_scalefactor;
 public:
  SubbandLayer1IntensityStereo(uint32 subbandnbr) : SubbandLayer1(subbandnbr){}
  void read_allocation(AudioStream *stream, Header *header, Crc16 *crc){
    SubbandLayer1::read_allocation (stream, header, crc);
  }
  void read_scalefactor (AudioStream *, Header *);
  bool read_sampledata (AudioStream *stream){
    return SubbandLayer1::read_sampledata(stream);
  }
  bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *);
};


// class for layer I subbands in stereo mode:
class SubbandLayer1Stereo : public SubbandLayer1{
 protected:
  uint32 channel2_allocation;
  uint32 channel2_scalefactor;
  uint32 channel2_samplelength;
  real	 channel2_sample;
  real	 channel2_factor, channel2_offset;
 public:
  SubbandLayer1Stereo(uint32 subbandnbr) : SubbandLayer1(subbandnbr){}
  void read_allocation(AudioStream *, Header *, Crc16 *);
  void read_scalefactor(AudioStream *, Header *);
  bool read_sampledata(AudioStream *);
  bool put_next_sample(e_channels, SynthesisFilter *, SynthesisFilter *);
};

#endif
