/*
   File: athread.hh
   
   By: Alex Theo de Jong
   Created: March, 1996
   
   Description:
   Alex' Threads based on pthreads
*/

#include "athread.hh"

int Errors::errcount=0;

#ifndef SOLARIS_PTHREAD

#endif // SOLARIS_PTHREAD


#ifdef SOLARIS

#endif // SOLARIS


#ifndef IRIX_PTHREAD

#endif // IRIX_PTHREAD

#ifdef IRIX

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

// create shared arena space
SharedArena SA::_sa;
 
SharedArena::SharedArena(){
  timeval tv;
  if (gettimeofday(&tv, 0)!=0){
    cerr << "could not get timeofday to create shared memory space\n";
    exit(1);
  }
  sprintf(filename, "/tmp/%d", (int) tv.tv_sec);
  if (!(handle=usinit(filename))){
    cerr << "could not create shared memory space on `" << filename << "'\n";
    exit(1);
  }
  chmod(filename, S_IRUSR |  S_IWUSR | S_IRGRP |  S_IWGRP | S_IROTH |  S_IWOTH);
}

SharedArena::~SharedArena(){
  usdetach(handle); 
  //  char command[100];
  //  sprintf(command, "rm -f %s", filename);
  //  system(command);  // remove tmp file
  unlink(filename);
}


void* (*_Thread_library::function_call)(void*)=0;
usema_t* _Thread_library::funct_sema=0;
ulock_t _Thread_library::mlock=0;
athr_t** _Thread_library::_thread_list=(athr_t**) new (athr_t*)[_thread_list_max];

int _Thread_library::init(){
  funct_sema=usnewsema(_sa.handle, 1);
  if (usinitsema(funct_sema, 1)<0) return -1;
  mlock=usnewlock(_sa.handle);
  if (usinitlock(mlock)<0) return -1;
  for (int i=0; i<_thread_list_max; i++) _thread_list[i]=0;
  return 1;
}

static int _Thread_library=_Thread_library::init();

#endif // IRIX
