/*
  File: test.cc

  Decription:
  Small test program for network utilities

  Created: 08/01/1996, Alex Theo de Jong, NIST
*/

#include <stdio.h>
#include <stdlib.h>
#include <String.h>
#include <fstream.h>
#include <sys/time.h>
#include <sys/errno.h>
#ifdef IRIX
#include <bstring.h>
#include <stropts.h>
#include <poll.h>
#endif

#include "error.hh"
#include "debug.hh"
#include "util.hh"

#include "network.hh"

main(int argc, char** argv){
  unsigned int asap=5000;
  unsigned int size=376;
  unsigned char* data;
  SocketMulti* socket;
  int vci=160;
  int i=0;

  if (argc>1){
    size=atoi(argv[1]);
    if (argc>2) vci=atoi(argv[2]);
  }

  data=new unsigned char[size];
  socket=new SocketMulti(asap, size, vci);

  message("Start ...");

  if (socket->accept()<0){
    error("could not accept call");
    exit(0);
  }

  while (socket->recv(data, size)>0){
    i++;
    if ((i % 1000)==0) msg(".");
  }
  msg("\n");

  delete data;
  delete socket;

  message("Done!");

  exit(0);
};
