/*
   File: videoconst.hh

   By: Alex Theo de Jong
   Created: March 1996

   Description:
   Video constants
*/

#define CHROMA420     1     // chroma_format
#define CHROMA422     2
#define CHROMA444     3

#define TOP_FIELD     1     // picture structure
#define BOTTOM_FIELD  2
#define FRAME_PICTURE 3

#define SEQ_ID        1     // extension start code IDs
#define DISP_ID       2
#define QUANT_ID      3
#define SEQSCAL_ID    5
#define PANSCAN_ID    7
#define CODING_ID     8
#define SPATSCAL_ID   9
#define TEMPSCAL_ID  10

#define ERROR (-1)

#define SC_NONE       0   // scalable_mode
#define SC_DP         1
#define SC_SPAT       2
#define SC_SNR        3
#define SC_TEMP       4

#define I_TYPE        1     // picture coding type
#define P_TYPE 2
#define B_TYPE 3
#define D_TYPE 4

#define MB_INTRA    1       // macroblock type
#define MB_PATTERN  2
#define MB_BACKWARD 4
#define MB_FORWARD  8
#define MB_QUANT    16
#define MB_WEIGHT   32
#define MB_CLASS4   64

#define MC_FIELD 1          // motion_type
#define MC_FRAME 2
#define MC_16X8  2
#define MC_DMV   3

#define MV_FIELD 0          // mv_format
#define MV_FRAME 1
