
/*
 * Audio Video PES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#ifndef __AVP_H__
#define __AVP_H__

#include <inttypes.h>

typedef struct {
	uint8_t prefix1			:8;	// 'A'
	uint8_t prefix2			:8;	// 'V'
	uint8_t stream_id		:8;	// 0x01 == Video, 0x02 == Audio 
	uint8_t cont_count		:8;	// continuity counter
	uint8_t reserved		:8;	// 0x55

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t nothing 		:3;
	uint8_t pts_present		:1;	// presentation time stamp		
	uint8_t stuff_pre		:2;	// bytes left for 4 byte pad
	uint8_t stuff_post		:2;	// bytes left for 4 byte pad (last pkt)
#else
	uint8_t stuff_post		:2;	// bytes left for 4 byte pad (last pkt)
	uint8_t stuff_pre		:2;	// bytes left for 4 byte pad
	uint8_t pts_present		:1;	// presentation time stamp		
	uint8_t nothing			:3;
#endif

	uint8_t length_hi		:8;	// payload length (high byte)
	uint8_t length_lo		:8;	// payload length (low byte)
} avp_hdr_t;

#define AVP_HDR_LEN 8
#define AVP_HDR_LEN4 2

#define AVP_VIDEO	0x01
#define AVP_AUDIO	0x02

#endif
