
/*
 * EVENT INFORMATION TABLE
 *
 * Copyright (C) 1998  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#ifndef __EIT_H__
#define __EIT_H__

// Service Description Section
#include <inttypes.h>

struct eit_struct {
	uint8_t table_id			: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t section_syntax_indicator	: 1;
	uint8_t 				: 3;
	uint8_t section_length_hi		: 4;
#else
	uint8_t section_length_hi		: 4;
	uint8_t 				: 3;
	uint8_t section_syntax_indicator	: 1;
#endif

	uint8_t section_length_lo		: 8;

	uint8_t service_id_hi			: 8;
	uint8_t service_id_lo			: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t 				: 2;
	uint8_t version_number			: 5;
	uint8_t current_next_indicator		: 1;
#else
	uint8_t current_next_indicator		: 1;
	uint8_t version_number			: 5;
	uint8_t 				: 2;
#endif

	uint8_t section_number			: 8;
	uint8_t last_section_number		: 8;
	uint8_t transport_stream_id_hi		: 8;
	uint8_t transport_stream_id_lo		: 8;
	uint8_t original_network_id_hi		: 8;
	uint8_t original_network_id_lo		: 8;
	uint8_t segment_last_section_number	: 8;
	uint8_t segment_last_table_id		: 8;
};

#define EIT_SIZE 14

struct eit_loop_struct1 {
	uint8_t service_id_hi			: 8;
	uint8_t service_id_lo			: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t 				: 6;
	uint8_t eit_schedule_flag		: 1;
	uint8_t eit_present_following_flag	: 1;

	uint8_t running_status			: 3;
	uint8_t free_ca_mode			: 1;
	uint8_t descriptors_loop_length_hi	: 4;
#else
	uint8_t eit_present_following_flag	: 1;
	uint8_t eit_schedule_flag		: 1;
	uint8_t 				: 6;

	uint8_t descriptors_loop_length_hi	: 4;
	uint8_t free_ca_mode			: 1;
	uint8_t running_status			: 3;
#endif

	uint8_t descriptors_loop_length_lo	: 8;
};

#define EIT_SHORT_EVENT_DESCRIPTOR 0x4d
#define EIT_SHORT_EVENT_DESCRIPTOR_SIZE 6

struct eit_short_event_descriptor_struct {
	uint8_t descriptor_tag			: 8;
	uint8_t descriptor_length		: 8;
	
	uint8_t language_code_1		: 8;
	uint8_t language_code_2		: 8;
	uint8_t language_code_3		: 8;

	uint8_t event_name_length		: 8;
};
	
#define EIT_EXTENDED_EVENT_DESCRIPOR 0x4e

#define EIT_DESCRIPTOR_SIZE 

struct eit_loop_struct {
	uint8_t event_id_hi			: 8;
	uint8_t event_id_lo			: 8;
	
	uint8_t start_time_1			: 8;
	uint8_t start_time_2			: 8;
	uint8_t start_time_3			: 8;
	uint8_t start_time_4			: 8;
	uint8_t start_time_5			: 8;

	uint8_t duration_1			: 8;
	uint8_t duration_2			: 8;
	uint8_t duration_3			: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t running_status			: 3;
	uint8_t free_CA_mode			: 1;
	uint8_t descriptors_loop_length_hi	: 4;
#else
	uint8_t descriptors_loop_length_hi	: 4;
	uint8_t free_CA_mode			: 1;
	uint8_t running_status			: 3;
#endif

	uint8_t descriptors_loop_length_lo	: 8;
	
};
#define EIT_LOOP_SIZE 12

struct eit_extended_descriptor_struct {
};

#endif	
