
/*
 * MULTI PROTOCOL ENCAPSULATION
 *
 * Copyright (C) 1999 Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __MPE_H__
#define __MPE_H__

#include <inttypes.h>

#define MPE_TABLE_ID	0x3E
#define MPE_HEADER_LEN	12

typedef struct mpe_header_struct {
	uint8_t table_id		: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t section_syntax_indicator: 1;
	uint8_t private_indicator	: 1;
	uint8_t			: 2;
	uint8_t section_length_hi	: 4;
#else
	uint8_t section_length_hi	: 4;
	uint8_t			: 2;
	uint8_t private_indicator	: 1;
	uint8_t section_syntax_indicator: 1;
#endif

	uint8_t section_length_lo	: 8;

	uint8_t MAC_address_6		: 8;

	uint8_t MAC_address_5		: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t			: 2;
	uint8_t payload_scrambling_control: 2;
	uint8_t address_scrambling_control: 2;
	uint8_t LLC_SNAP_flag		: 1;
	uint8_t current_next_indicator	: 1;
#else
	uint8_t current_next_indicator	: 1;
	uint8_t LLC_SNAP_flag		: 1;
	uint8_t address_scrambling_control: 2;
	uint8_t payload_scrambling_control: 2;
	uint8_t			: 2;
#endif

	uint8_t section_number		: 8;

	uint8_t last_section_number	: 8;

	uint8_t MAC_address_4		: 8;

	uint8_t MAC_address_3		: 8;

	uint8_t MAC_address_2		: 8;

	uint8_t MAC_address_1		: 8;
} mpe_hdr_t;

#endif
