
/*
 * PROGRAM ASSOCIATION TABLE
 *
 * Copyright (C) 1998  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#ifndef __PAT_H__
#define __PAT_H__

#include <inttypes.h>

#define PAT_LEN 8

typedef struct {
	uint8_t table_id			:8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t section_syntax_indicator	:1;
	uint8_t dummy				:1;	// has to be 0
	uint8_t 				:2;
	uint8_t section_length_hi		:4;
#else
	uint8_t section_length_hi		:4;
	uint8_t 				:2;
	uint8_t dummy				:1;	// has to be 0
	uint8_t section_syntax_indicator	:1;
#endif

	uint8_t section_length_lo		:8;

	uint16_t transport_stream_id		:16;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t 				:2;
	uint8_t version_number			:5;
	uint8_t current_next_indicator		:1;
#else
	uint8_t current_next_indicator		:1;
	uint8_t version_number			:5;
	uint8_t 				:2;
#endif
 
	uint8_t section_number			:8;
	uint8_t last_section_number		:8;
} pat_t;

#define PAT_PROG_LEN 4

typedef struct {
	uint16_t program_number			:16;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t 				:3;
	uint8_t network_pid_hi			:5;
#else
	uint8_t network_pid_hi			:5;
	uint8_t 				:3;
#endif

	uint8_t network_pid_lo			:8; 
	/* or program_map_pid (if prog_num=0)*/
} pat_prog_t;

#endif
