
/*
 * PROGRAM MAP TABLE
 *
 * Copyright (C) 1998  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __PMT_H__
#define __PMT_H__

#include <inttypes.h>

#define PMT_LEN 12

struct pmt_struct {
	uint8_t table_id			: 8;
  
	uint8_t					: 2;
	uint8_t dummy				: 1; // has to be 0
	uint8_t section_syntax_indicator	: 1;
	uint16_t section_length			: 12;
  
	uint16_t program_number			: 16;

	uint8_t current_next_indicator		: 1;
	uint8_t version_number			: 5;
	uint8_t					: 2;

	uint8_t section_number			: 8;
	
	uint8_t last_section_number		: 8;

	uint8_t					: 3;
	uint16_t PCR_PID			: 13;

	uint8_t					: 4;
	uint16_t program_info_length		: 12;
	//descriptors
};

#define PMT_info_LEN 5

struct pmt_info_struct {
	uint8_t stream_type			: 8;

	uint8_t					: 3;
	uint16_t elementary_PID			: 13;

	uint8_t					: 4;
	uint16_t ES_info_length			: 12;
	// descriptors
};

#endif
