
/*
 * SERVICE DESCRIPTION TABLE
 *
 * Copyright (C) 1998  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#ifndef __SDT_H__
#define __SDT_H__

#include <inttypes.h>

#define SDT_LEN 11

typedef struct {
	uint8_t table_id			: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t section_syntax_indicator	: 1;
	uint8_t					: 3;
	uint8_t section_length_hi		: 4;
#else
	uint8_t section_length_hi		: 4;
	uint8_t					: 3;
	uint8_t section_syntax_indicator	: 1;
#endif

	uint8_t section_length_lo		: 8;

	uint8_t transport_stream_id_hi		: 8;
	uint8_t transport_stream_id_lo		: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t					: 2;
	uint8_t version_number			: 5;
	uint8_t current_next_indicator		: 1;
#else
	uint8_t current_next_indicator		: 1;
	uint8_t version_number			: 5;
	uint8_t					: 2;
#endif

	uint8_t section_number			: 8;
	uint8_t last_section_number		: 8;
	uint8_t original_network_id_hi		: 8;
	uint8_t original_network_id_lo		: 8;
	uint8_t					: 8;
} sdt_t;

#define SDT_DESCR_LEN 5

struct sdt_descr_struct {
	uint8_t service_id_hi			: 8;
	uint8_t service_id_lo			: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t					: 6;
	uint8_t eit_schedule_flag		: 1;
	uint8_t eit_present_following_flag	: 1;

	uint8_t running_status			: 3;
	uint8_t free_ca_mode			: 1;
	uint8_t descriptors_loop_length_hi	: 4;
#else
	uint8_t eit_present_following_flag	: 1;
	uint8_t eit_schedule_flag		: 1;
	uint8_t					: 6;

	uint8_t descriptors_loop_length_hi	: 4;
	uint8_t free_ca_mode			: 1;
	uint8_t running_status			: 3;
#endif

	uint8_t descriptors_loop_length_lo	: 8;
};
typedef struct sdt_descr_struct sdt_descr_t;

#define SDT_SERVICE_DESCRIPTOR 0x48

struct sdt_generic_descriptor {
	uint8_t descriptor_tag			: 8;
	uint8_t descriptor_length		: 8;
};
	
struct sdt_service_descriptor_1 {
	uint8_t service_type			: 8;
	uint8_t service_provider_name_length	: 8;
};

struct sdt_service_descriptor_2 {
	uint8_t service_name_length		: 8;
};

struct sdt_service_desc {
	uint8_t description_tag			: 8;
	uint8_t description_length		: 8;
	uint8_t service_type			: 8;
	uint8_t service_provider_name_length	: 8;	
};

#endif	
