
/*
 * TRANSPORT STREAM
 *
 * Copyright (C) 1998, 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __TS_H__
#define __TS_H__

#include <inttypes.h>

#define TS_SYNC_BYTE	0x47

#define TS_LEN	188
#define TS_HDR_LEN 4
#define TS_DATA_LEN (TS_LEN - TS_HDR_LEN)

typedef struct {
	uint8_t sync_byte			: 8;	/* should be 0x47 */

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t transport_error_indicator	: 1;
	uint8_t payload_unit_start_indicator	: 1;
	uint8_t transport_priority		: 1;
	uint8_t PID_hi				: 5;
#else
	uint8_t PID_hi				: 5;
	uint8_t transport_priority		: 1;
	uint8_t payload_unit_start_indicator	: 1;
	uint8_t transport_error_indicator	: 1;
#endif
	uint8_t PID_lo				: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t transport_scrambling_control	: 2;
	uint8_t adaptation_field_control	: 2;
	uint8_t continuity_counter		: 4;
#else
	uint8_t continuity_counter		: 4;
	uint8_t adaptation_field_control	: 2;
	uint8_t transport_scrambling_control	: 2;
#endif
} ts_hdr_t;

#define TS_ADAPTATION_FIELD_LEN 1

typedef struct {
#if BYTE_ORDER == BIG_ENDIAN
	uint8_t discontinuity_indicator     		: 1;
	uint8_t random_access_indicator	       	: 1;
	uint8_t elementary_stream_priority_indicator	: 1;
	uint8_t pcr_flag			       	: 1;
	uint8_t opcr_flag				: 1;
	uint8_t splicing_point_flag	       		: 1;
	uint8_t transport_private_data_flag     	: 1;
	uint8_t adaptation_field_extension_flag 	: 1;
#else
	uint8_t adaptation_field_extension_flag 	: 1;
	uint8_t transport_private_data_flag     	: 1;
	uint8_t splicing_point_flag	       		: 1;
	uint8_t opcr_flag				: 1;
	uint8_t pcr_flag			       	: 1;
	uint8_t elementary_stream_priority_indicator	: 1;
	uint8_t random_access_indicator		       	: 1;
	uint8_t discontinuity_indicator		       	: 1;
#endif
} ts_adapt_fld_t;

#define TS_PCR_LEN 6

typedef struct {
	uint8_t program_clock_reference_base_1		: 8;

	uint8_t program_clock_reference_base_2		: 8;

	uint8_t program_clock_reference_base_3		: 8;

	uint8_t program_clock_reference_base_4		: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t program_clock_reference_base_5		: 1;
	uint8_t 					: 6;
	uint8_t program_clock_reference_extension_hi	: 1;
#else
	uint8_t program_clock_reference_extension_hi	: 1;
	uint8_t 					: 6;
	uint8_t program_clock_reference_base_5		: 1;
#endif

	uint8_t program_clock_reference_extension_lo	: 8;
} ts_pcr_t;

struct ts_opcr_struct {
	uint64_t original_program_clock_reference_base : 33;
	uint8_t reserved				: 6;
	uint16_t original_program_clock_reference_extension: 9;
};

struct ts_splicing_point_struct {
	uint8_t splice_countdown			: 8;
};

struct ts_transport_private_data_struct {
	uint8_t transport_private_data_length		: 8;
};

struct ts_adaptation_field_extension_struct {
#if BYTE_ORDER == BIG_ENDIAN
	uint8_t reserved				: 5;
	uint8_t seamless_splice_flag			: 1;
	uint8_t piecewise_rate_flag			: 1;
	uint8_t ltw_flag				: 1;
	uint8_t adaptation_field_extension_length	: 8;
#else
	uint8_t adaptation_field_extension_length	: 8;
	uint8_t ltw_flag				: 1;
	uint8_t piecewise_rate_flag			: 1;
	uint8_t seamless_splice_flag			: 1;
	uint8_t reserved				: 5;
#endif
};

// TODO: CHECK DOWN HERE

struct ts_ltw_struct {
	uint8_t ltw_calid_flag				: 1;
	uint16_t ltw_offset				: 15;
};

struct ts_piecewise_rate_struct {
	uint8_t reserved				: 2;
	uint32_t piecewise_rate				: 22;
};

struct ts_seamless_splice_struct {
	uint8_t splice_type				: 4;
	uint8_t DTS_next_AU_32_30			: 3;
	uint8_t marker_bit0				: 1;
	uint16_t DTS_next_AU_29_15			: 15;
	uint8_t marker_bit1				: 1;
	uint16_t DTS_next_AU_14_0			: 15;
	uint8_t marker_bit2				: 1;
};

#define TS_PAYLEN	184
#define TS_NOSYNC	-1	/* no valid sync byte */
#define TS_NODATA	-2	/* no payload */
#define TS_SCRAMBLED	-3	/* scrambled - and we can't descramble it */
#define TS_INPKT	-4	/* doing our reassembling task */
#define TS_UNKNOWN	-5	/* an unknown error appeared */

/***** access functions *****/

static inline uint16_t _ts_get_pid (ts_hdr_t *ts)
{
	return	(ts->PID_hi << 8) |
		(ts->PID_lo);
}
#endif
