/*
 *  Copyright (C) 2000 Yoann Vandoorselaere.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors: Yoann Vandoorselaere <yoann@mandrakesoft.com>
 *
 */

typedef struct {
	char *filename;		/* filename for this session */
	char **content;		/* content of the file */
	int need_sync;		/* do the file need to be synced on disk ? */
	int elements;		/* array number of elements */
	int refcount;		/* Number of place referencing this object */
} config_t;

const char *config_get(config_t * cfg, const char *section,
		       const char *entry);

int config_set(config_t * cfg, const char *section, const char *entry,
	       const char *val);

config_t *config_open(const char *filename);

int config_close(config_t * cfg);

int config_write(config_t * cfg);

int config_del(config_t * cfg, const char *section, const char *entry);
