/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __PLUGIN_GENERIC_H__
#define __PLUGIN_GENERIC_H__

#include <inttypes.h>
#include <sys/types.h>

#include <oms/fourcc.h>
#include <oms/plugin/id.h>

#ifdef STATIC
# define PLUGIN_INIT(x)  x ## _init
# define PLUGIN_EXIT(x)  x ## _exit
#else
# define PLUGIN_INIT(x) plugin_init
# define PLUGIN_EXIT(x) plugin_exit
#endif

#define PLUGIN_GENERIC					\
        void *priv;					\
        void (*config)	(void);				\
	int (*ctrl)	(void *this, uint ctrl_id, ...);\
        int (*open)     (void *this, void *name);	\
        int (*close)    (void *this)

typedef struct plugin_s {
	PLUGIN_GENERIC;
} plugin_t;

/**
 * whoami       : pathname of the plugin
 * plugin_id    : input, decaps, codec_audio, codec_video, ...
 * fourcc_in    : input type list as four character codes, deliminated by ';'
 * fourcc_out   : output type list as four character codes, deliminated by ';'
 * xml_config   : xml configuration string
 **/

int pluginRegister (char *whoami, uint32_t plugin_id, char *fourcc_in,
		    char *fourcc_out, char *xml_config, void *plugin_data);

#endif
