/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __NAV_PLUGIN_H__
#define __NAV_PLUGIN_H__

#include <oms/plugin/generic.h>

/***** structs *****/
typedef struct {
	char *name;		// Chapter Name
} nav_tree_data_t;

typedef struct {
	int num;		// Number of Chapters
	char *name;		// Title Name
	nav_tree_data_t *sub;	// Chapters
} nav_subtree_t;

typedef struct {
	int num;		// Number of Titles
	nav_subtree_t *title;	// Titles
} nav_tree_t;

typedef struct plugin_nav_struct {
	PLUGIN_GENERIC;
// play
	int (*play) (int title, int chapter, int parts2play);
// get Information
	nav_tree_t *(*get_info) (uint32_t id);
// register callback
	int (*register_cb) (uint32_t id, oms_callback_t cb, void *data);
// unregister callback
	int (*unregister_cb) (uint32_t id);
} plugin_nav_t;

#endif
