
/*
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __OUTPUT_AUDIO_H__
#define __OUTPUT_AUDIO_H__

#include <oms/plugin/generic.h>

// for AFMT_* entries
#if defined (__OpenBSD__)
#	include <soundcard.h>
#elif defined (__FreeBSD__)
#	include <machine/soundcard.h>
#elif defined (__sun__)
#	include <sys/audioio.h>
#else
#	include <sys/soundcard.h>
#endif

// AUDIO ERRORS (ioctl errors)
#define AE_CHANNELS	0x01
#define AE_FORMAT	0x02
#define AE_SPEED	0x04

typedef struct plugin_output_audio_attr_struct {
	int format;
	int speed;
	int channels;
} plugin_output_audio_attr_t;

typedef struct plugin_output_audio_struct {
	PLUGIN_GENERIC;

	int (*setup) (plugin_output_audio_attr_t * attr);
// write audio (play)
	int (*write) (const void *buf, size_t num_bytes);
// check status
	int (*check) (void);
// read pts
	 uint32_t (*read_pts) (void);
} plugin_output_audio_t;

#endif
