dnl ==========
dnl misc kernel/DVD stuff by <dent@linuxvideo.org>
dnl ==========

dnl ==========
dnl get location of kernel headers
dnl ==========
dnl cache results

AC_DEFUN([AC_C_KERNEL_INCLUDES],
	[AC_CACHE_CHECK([for kernel-inclues], ac_cv_path_kernel_includes,
		[AC_ARG_WITH(kernel-includes,
        	[  --with-kernel-includes=DIR kernel include files are in DIR
                	[/usr/src/linux/include]],
        	[KERNEL_INCLUDES="$withval"],
        	[KERNEL_INCLUDES=/usr/src/linux/include])
	
		AC_MSG_CHECKING($KERNEL_INCLUDES)
	
		if test -d "${KERNEL_INCLUDES}"; then
			AC_MSG_RESULT(found)
			ac_cv_path_kernel_includes=${KERNEL_INCLUDES}
		else
			AC_MSG_RESULT(not found)
			AC_MSG_WARN(missing kernel includes directory)
		fi
		])

	KERNEL_INCLUDES=${ac_cv_path_kernel_includes}
	AC_SUBST(KERNEL_INCLUDES)
])


dnl ==========
dnl test for DVD ioctls <dent@linuxvideo.org>
dnl ==========
dnl - add check for kernel includes here, if not found ...

AC_DEFUN([AC_C_DVDIOCTLS],
	[AC_CACHE_CHECK([for dvd_authinfo], ac_cv_type_dvd_authinfo,
        	[ac_save_CFLAGS=$CFLAGS
		CFLAGS="$CFLAGS -I$KERNEL_INCLUDES"

		AC_TRY_COMPILE([
			#if defined(__NetBSD__) || defined(__OpenBSD__)
			# include <sys/dvdio.h>
			#elif defined(__linux__)
			# include <sys/types.h>
			# include <linux/cdrom.h>
			#else
			# error "Need the DVD ioctls"
		#endif], [dvd_authinfo ai; ai.type=42;],
		ac_cv_type_dvd_authinfo=yes, ac_cv_type_dvd_authinfo=no)])

		if test x$ac_cv_type_dvd_authinfo = xyes; then
			AC_DEFINE(HAVE_DVD_AUTHINFO,1,[Define if system has dvd authinfo type])
			AM_CONDITIONAL(HAVE_DVD_AUTHINFO,true)
		else
			AM_CONDITIONAL(HAVE_DVD_AUTHINFO,false)
		fi

		CFLAGS=$ac_save_CFLAGS
])
