
/*
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <inttypes.h>
#include <sys/stat.h>

#include "dvddb.h"

#define DEVICE "/dev/dvd"

/**
 *
 */

int main (int argc, char *argv[])
{
	int sock;
	char id[9];
	int fd;

	if (argc != 2) {
		fprintf (stderr, "USAGE: %s <filename>\n", argv[0]);
		fprintf (stderr, "\t (see testfile for example\n");
		return -1;
	}

	if ((fd = open (argv[1], O_RDONLY)) < 0) {
		fprintf (stderr, "unable to open input file (%s)\n", argv[1]);
		return -1;
	}
 
	dvddbGetID (DEVICE, id);

	if ((sock = dvddbNetConnect ()) < 0)
		return -1;

	dvddbNetPut (sock, fd, id);
	dvddbNetDisconnect (sock);

	fprintf (stderr, "THANKS FOR YOUR SUBMISSION\n");
	fprintf (stderr, "--------------------------\n");

	close (fd);

	return 0;
}
