
/*
 *
 * Copyright (C) 1998-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <inttypes.h>

#include "ifo.h"

char version[] = "V0.1.3";

int main (int argc, char **argv)
{
	ifo_t *ifo;
	int fd;

	printf ("free InFormatiOn project %s\n", version);
	printf ("--------------------------------\n");
	printf ("(c) 1999-2000 by Thomas Mirlacher\n\n");

	if ((fd = open (argv[1], O_RDONLY)) < 0) {
		fprintf (stderr, "error opening file %s.\n", argv[1]);
		return -1;
	}

	if (!(ifo = ifoOpen (fd, 0))) {
		fprintf (stderr, "error initializing ifo.\n");
		return -1;
	}

	ifoPrintVideo (ifo->tbl[ID_MAT] + IFO_OFFSET_VIDEO);

	if (!ifoIsVTS (ifo)) {
		uint8_t *ptr;
		int num;

		if ((num = ifoGetAudio (ifo->tbl[ID_MAT] + IFO_OFFSET_AUDIO, &ptr)) > 0)
			ifoPrintAudio (ptr, num);

		if ((num = ifoGetSPU (ifo->tbl[ID_MAT] + IFO_OFFSET_SUBPIC, &ptr)) > 0)
			ifoPrintSPU ((ifo_spu_t *) ptr, num);

		//ifoPrintSPU (ifoGetSPU (ifo->tbl[ID_MAT] + IFO_OFFSET_SUBPIC));

		ifoPrint_TMAPT (ifo);

		ifoPrint_ptt (ifoGetPTT (ifo));
	}

	if (!ifoIsVMG (ifo)) {
		printf ("\nFIRST PGC\n");
		printf ("---\n\n");
		ifoPrint_pgc_cmd (ifoGetFirstPGC (ifo));

//FIXME		ifo_print_audiosub (ifo->tbl[ID_VTS_ATRT]);
//NEW		ifoPrint_PTT_SRPT (ifo);

//		ifoPrint_ptt (ifo_get_ptt (ifo));
		ifoPrint_TXTDT_MGI (ifo);

	}

	ifoPrint_pgci		(ifo, IFO_TITLE);
	ifoPrint_vts_caddr	(ifo, IFO_TITLE);
	ifoPrint_VOBU_ADMAP	(ifo, IFO_TITLE);

	ifoPrint_pgci		(ifo, IFO_MENU);
	ifoPrint_vts_caddr	(ifo, IFO_MENU);
	ifoPrint_VOBU_ADMAP	(ifo, IFO_MENU);

	ifoClose (ifo);

	return 0;
}
