
/*
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <inttypes.h>
#include <netinet/in.h>

#include "ifo.h"

char version[] = "V0.1.2";
extern void ifoPrint_pgc_cmd (u_char *pgc_ptr);
/**
 *
 */

int main (int argc, char **argv)
{
	ifo_t *ifo;
	int fd;

	printf ("free InFormatiOn project %s\n", version);
	printf ("displays Commands\n");
	printf ("--------------------------------\n");
	printf ("(c) 1999-2000 by Thomas Mirlacher\n\n");

	if ((fd = open (argv[1], O_RDONLY)) < 0) {
		fprintf (stderr, "error opening file %s.\n", argv[1]);
		exit (-1);
	}

	if (!(ifo = ifoOpen (fd, 0))) {
		fprintf (stderr, "error initializing ifo.\n");
		exit (-1);
	}

{
	int i;
	ifo_hdr_t *hdr = (ifo_hdr_t *) ifo->tbl[ID_TITLE_PGCI];

	if (hdr) {
		printf ("TITLE PGCI commands:\n");
		printf ("--------------------\n");

		for (i=0; i<ntohs(hdr->num); i++) {
			const pgc_t *pgc;

			printf ("%d:\n---\n", i);

			if ((pgc = ifoGetPGCI (ifo, IFO_TITLE, i)))
				ifoPrint_pgc_cmd ((uint8_t *) pgc);

			printf ("\n");
		}
	}
}

{
	int i, s;
	ifo_hdr_t *_hdr = (ifo_hdr_t *) ifo->tbl[ID_MENU_PGCI];

	if (_hdr) {
		printf ("MENU PGCI commands:\n");
		printf ("--------------------\n");

		for (i=0; i<ntohs(_hdr->num); i++) {
			ifo_hdr_t *hdr;

			printf ("lu%d:\n---\n", i+1);

			if ((hdr = (ifo_hdr_t *) ifoGetPGCI (ifo, IFO_MENU, i)))
				return -1;

			for (s=0; s<ntohs(hdr->num); s++) {
//				uint8_t *ptr_pgc;

				printf ("%d:\n---\n", s+1);

// DENT: fixme			
//				if ((ptr_pgc = ifoGetMenuPGCI (hdr, s)))
//					ifoPrint_pgc_cmd (ptr_pgc);

				printf ("\n");
			}
		}
	}
}

	close (fd);

	return 0;
}
