
/*
 *
 * Copyright (C) 1998-1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <string.h>
#include <inttypes.h>

#include <bswap.h>

static struct {
	char descr[3];
        char lang_long[20];
} lang_tbl[] = {

/* The ISO 639 language codes.
 * Language names with * prefix are not spelled in their own language 
 */
	{"  ", "Not Specified"},
	{"aa", "*Afar"},
	{"ab", "*Abkhazian"},
	{"af", "*Afrikaans"},
	{"am", "*Amharic"},
	{"ar", "*Arabic"},
	{"as", "*Assamese"},
	{"ay", "*Aymara"},
	{"az", "*Azerbaijani"},
	{"ba", "*Bashkir"},
	{"be", "*Byelorussian"},
	{"bg", "*Bulgarian"},
	{"bh", "*Bihari"},
	{"bi", "*Bislama"},
	{"bn", "*Bengali; Bangla"},
	{"bo", "*Tibetan"},
	{"br", "*Breton"},
	{"ca", "*Catalan"},
	{"co", "*Corsican"},
	{"cs", "*Czech(Ceske)"},
	{"cy", "*Welsh"},
	{"da", "Dansk"},
	{"de", "Deutsch"},
	{"dz", "*Bhutani"},
	{"el", "*Greek"},
	{"en", "English"},
	{"eo", "*Esperanto"},
	{"es", "Espanol"},
	{"et", "*Estonian"},
	{"eu", "*Basque"},
	{"fa", "*Persian"},
	{"fi", "Suomi"},
	{"fj", "*Fiji"},
	{"fo", "*Faroese"},
	{"fr", "Francais"},
	{"fy", "*Frisian"},
	{"ga", "*Irish"},
	{"gd", "*Scots Gaelic"},
	{"gl", "*Galician"},
	{"gn", "*Guarani"},
	{"gu", "*Gujarati"},
	{"ha", "*Hausa"},
	{"he", "*Hebrew"},				// formerly iw
	{"hi", "*Hindi"},
	{"hr", "Hrvatski"},				// Croatian
	{"hu", "Magyar"},
	{"hy", "*Armenian"},
	{"ia", "*Interlingua"},
	{"id", "*Indonesian"},				// formerly in
	{"ie", "*Interlingue"},
	{"ik", "*Inupiak"},
	{"in", "*Indonesian"},				// replaced by id
	{"is", "Islenska"},
	{"it", "Italiano"},
	{"iu", "*Inuktitut"},
	{"iw", "*Hebrew"},				// replaced by he
	{"ja", "*Japanese"},
	{"ji", "*Yiddish"},				// replaced by yi
	{"jw", "*Javanese"},
	{"ka", "*Georgian"},
	{"kk", "*Kazakh"},
	{"kl", "*Greenlandic"},
	{"km", "*Cambodian"},
	{"kn", "*Kannada"},
	{"ko", "*Korean"},
	{"ks", "*Kashmiri"},
	{"ku", "*Kurdish"},
	{"ky", "*Kirghiz"},
	{"la", "*Latin"},
	{"ln", "*Lingala"},
	{"lo", "*Laothian"},
	{"lt", "*Lithuanian"},
	{"lv", "*Latvian, Lettish"},
	{"mg", "*Malagasy"},
	{"mi", "*Maori"},
	{"mk", "*Macedonian"},
	{"ml", "*Malayalam"},
	{"mn", "*Mongolian"},
	{"mo", "*Moldavian"},
	{"mr", "*Marathi"},
	{"ms", "*Malay"},
	{"mt", "*Maltese"},
	{"my", "*Burmese"},
	{"na", "*Nauru"},
	{"ne", "*Nepali"},
	{"nl", "Nederlands"},
	{"no", "Norsk"},
	{"oc", "*Occitan"},
	{"om", "*(Afan) Oromo"},
	{"or", "*Oriya"},
	{"pa", "*Punjabi"},
	{"pl", "*Polish"},
	{"ps", "*Pashto, Pushto"},
	{"pt", "Portugues"},
	{"qu", "*Quechua"},
	{"rm", "*Rhaeto-Romance"},
	{"rn", "*Kirundi"},
	{"ro", "*Romanian"},
	{"ru", "*Russian"},
	{"rw", "*Kinyarwanda"},
	{"sa", "*Sanskrit"},
	{"sd", "*Sindhi"},
	{"sg", "*Sangho"},
	{"sh", "*Serbo-Croatian"},
	{"si", "*Sinhalese"},
	{"sk", "*Slovak"},
	{"sl", "*Slovenian"},
	{"sm", "*Samoan"},
	{"sn", "*Shona"},
	{"so", "*Somali"},
	{"sq", "*Albanian"},
	{"sr", "*Serbian"},
	{"ss", "*Siswati"},
	{"st", "*Sesotho"},
	{"su", "*Sundanese"},
	{"sv", "Svenska"},
	{"sw", "*Swahili"},
	{"ta", "*Tamil"},
	{"te", "*Telugu"},
	{"tg", "*Tajik"},
	{"th", "*Thai"},
	{"ti", "*Tigrinya"},
	{"tk", "*Turkmen"},
	{"tl", "*Tagalog"},
	{"tn", "*Setswana"},
	{"to", "*Tonga"},
	{"tr", "*Turkish"},
	{"ts", "*Tsonga"},
	{"tt", "*Tatar"},
	{"tw", "*Twi"},
	{"ug", "*Uighur"},
	{"uk", "*Ukrainian"},
	{"ur", "*Urdu"},
	{"uz", "*Uzbek"},
	{"vi", "*Vietnamese"},
	{"vo", "*Volapuk"},
	{"wo", "*Wolof"},
	{"xh", "*Xhosa"},
	{"yi", "*Yiddish"},				// formerly ji
	{"yo", "*Yoruba"},
	{"za", "*Zhuang"},
	{"zh", "*Chinese"},
	{"zu", "*Zulu"},
	{"\0", ""}
};


char *ifoDecodeLang (uint16_t descr)
{
	int i;

//	descr = be2me_16 (descr);

	for (i=0; lang_tbl[i].lang_long[0]; i++) {
		if (!memcmp (&descr, &lang_tbl[i].descr, 2)) {
			return (char *) lang_tbl[i].lang_long;
		}
	}

	printf ("descr: %x\n", descr);
	return lang_tbl[i].lang_long;
}


static struct {
        uint16_t descr;
        char descr_long[50];
} videomode_tbl[] = {
	{0x01, "Never The Same Color 29.97fps"},
	{0x02, "Never The Same Color 30fps"},
	{0x03, "PAL-B, D, G, H, I, 25 fps"},
	{0x04, "PAL-M 29.97 fps"},
	{0x05, "PAL-M 30 fps"},
	{0x06, "PAL-N 25 fps"},
	{0x07, "PAL-Nc 25 fps"},
	{0x08, "PAL 30 fps"},
	{0, ""}
};


char *decode_videomode (uint16_t descr)
{
        int i;

        for (i=0; videomode_tbl[i].descr; i++) {
                if (descr == videomode_tbl[i].descr) {
                        return (char *) videomode_tbl[i].descr_long;
                }
        }

        printf ("VIDEO 0x%0X", descr);
        return NULL;
}


char *decode_audiomode (uint16_t descr)
{
	static char audio_coding_mode[][9] = {
		"AC3",
		"???",
		"MPEG1",
		"MPEG2ext",
		"LPCM",
		"DTS",
		"SDDS"
	};

	return audio_coding_mode[descr&0x07];
}


char *decode_audiomodeappl (char descr)
{
	static char audio_appl_mode[][15] = {
		"Not Specified",
		"Karaoke",
		"Surround Sound"
	};

	return audio_appl_mode[descr&0x02];
}


static struct {
	char descr;
	char descr_long[25];
} audiocaption_tbl[] = {
	{0x01, "Normal Caption"},
	{0x03, "Directors Comments"},
	{0, ""}
};


char *decode_caption (char descr)
{
	int i;

	for (i=0; audiocaption_tbl[i].descr; i++) {
		if (descr == audiocaption_tbl[i].descr) {
			return (char *) audiocaption_tbl[i].descr_long;
		}
	}

	return NULL;
}


static char menu_id[][80] = {
        "-0-",
        "-1-",
        "Title (VTS menu)",
        "Root",
        "Sub-Picture",
        "Audio",
        "Angle",
        "Part of Title",
};


char *decode_menuname (char index)
{
	return menu_id[index&0x07];
}

// Part == Chapter

static char user_op[][40] = {
	"Title/Time Play",
	"Part Search/Play",
	"Title Play",
	"Stop",
	"GoUp",
	"Time/Part Search",
	"Prev/Top PG Search",
	"NextPG Search",
	"Forward Scan",
	"Backward Scan",
	"Title Menu Call",
	"Root Menu Call",
	"SubPic Menu Call",
	"Audio Menu Call",
	"Angle Menu Call",
	"Part Menu Call",
	"Resume",
	"Button Select/Activate",
	"Still Off",
	"Pause On",
	"Audio Stream Change",
	"SubPic Stream Change",
	"Angle Change",
	"Karaoke Audio Pres Mode Change",
	"Video Pres Mode Change"
};


void decode_user_op (uint32_t u_op)
{
	int i;

	for (i = 0; i < 25; i++) {
		if (!(u_op & (0x1 << i))) {
			printf ("\t\t\t%s\n", user_op[i]);
		}
	}
}
