
/*
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "ifo.h"
#include "misc.h"


inline uint32_t get4bytes (const uint8_t *buf)
{
	return be2me_32 (*((uint32_t *)buf));
}


inline uint16_t get2bytes (const uint8_t *buf)
{
	return be2me_16 (*((uint16_t *)buf));
}


int ifoReadTBL (ifo_t *ifo, off_t offset, uint8_t tbl_id)
{
	uint8_t *data;
	uint32_t len = 0;
	off_t pos;

	printf ("Reading TBL %d offset 0x%x\n", tbl_id, (uint32_t) offset*DVD_VIDEO_LB_LEN);

	if (!ifo || !offset)
		return -1;

	if (!(data =  (uint8_t *) calloc (DVD_VIDEO_LB_LEN/4, 4))) {
		LOG (LOG_ERROR, "%s", strerror (errno));
		return -1; 
	}

	pos =  ifo->pos + offset * DVD_VIDEO_LB_LEN;
	if (lseek (ifo->fd, pos, SEEK_SET) == -1) {
		LOG (LOG_ERROR, "error in lseek (pos: 0x%llx)", pos);
		return -1;
	}

	if (read (ifo->fd, data, DVD_VIDEO_LB_LEN) <= 0) {
		LOG (LOG_ERROR, "error reading file");
		return -1;
	}

	switch (tbl_id) {
		case ID_TITLE_VOBU_ADMAP:
		case ID_MENU_VOBU_ADMAP:
			len = get4bytes (data) + 1;
			break;

		default: {
			ifo_hdr_t *hdr = (ifo_hdr_t *) data;
			len = be2me_32 (hdr->len) + 1;
		}
	}

	if (len > DVD_VIDEO_LB_LEN) {
		if (!(data =  (uint8_t *) realloc ((void *) data, len))) {
			perror ("realloc");
			return -1; 
		}

		pos = ifo->pos + offset * DVD_VIDEO_LB_LEN;
		if (lseek (ifo->fd, pos, SEEK_SET) == -1) {
			LOG (LOG_ERROR, "error in lseek (pos: 0x%llx)", pos);
			return -1;
		}

		if (read (ifo->fd, data, len) <= 0) {
			LOG (LOG_ERROR, "error reading file");
			return -1;
		}
	}

	ifo->tbl [tbl_id] = data;

	return 0;
}
