#define AUTO_DROP_FRAMES
//#define MEMCHECK
//#define DEBUG

/*
 *
 * Copyright (C) 2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <dlfcn.h>
#include <inttypes.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <assert.h>

#ifdef MEMCHECK
#include <mcheck.h>
#endif

#include <oms/oms.h>
#include <oms/plugin.h>
#include <oms/fourcc.h>
#include <oms/buf.h>

#include <oms/plugin/decaps.h>
#include <oms/plugin/codec.h>
#include <oms/plugin/output_audio.h>


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include "render_mgr.h"
#include "thread_input.h"
#include "thread_demux.h"

static struct {
	int audio;
	int subpic;
} current;

static buf_t *buf = NULL;

static int _parse_uri (char *uri, char **uri_type, char **uri_path) 
{
        char *ptr = strchr (uri, ':');

        if (!uri || !strlen (uri) )
		return -1;

        if (ptr) {
                *ptr = 0;
                *uri_path = ptr + 1;
                *uri_type = uri;
        } else {
                *uri_path = uri;
                *uri_type = NULL;
        }
	return 0;
}


/**
 * initialize oms
 **/

int oms_init (void)
{
#ifdef MEMCHECK
	mtrace ();
#endif

        omsConfigOpen();
        
	if (!(buf = oms_buf_init ()))
		return -1;

        LOG (LOG_INFO, "BUF allocated! %p", buf);
	plugin_mgr_init ();
        
	return 0;
}


int oms_exit (void)
{
	return plugin_mgr_exit ();
}

/**
 * open input device/file and associated plugins
 **/

int omsOpenInput (char *uri)
{
	int ret;
	struct stat info;
	char *uri_type, *uri_path;
	
        LOG (LOG_DEBUG, "opening URI: %s", uri);

        uri = strdup (uri);
        if (_parse_uri (uri, &uri_type, &uri_path) < 0)
		return -1;
        
// just to be sure to have old stuff closed, before heading for new things 
        omsCloseInput();
        
	if (stat (uri_path, &info) < 0) {
               LOG (LOG_DEBUG, "path (%s) NOT found", uri_path);
               free (uri);
               return -1; 
        }
       
	oms_thread_demux_set_status (STATUS_STOP);
        
	if (pluginLoad (PLUGIN_ID_NAV, uri_type, NULL) < 0) {
                free (uri);
                return -1;
        }

	ret = plugin_init_nav (uri_path);
        free (uri);

	return ret;
}


/**
 * close current input device/file and associated plugins
 **/

int omsCloseInput (void)
{
	// stop player if still running
	oms_set_status (STATUS_STOP);
	plugin_unload (PLUGIN_ID_INPUT);

	plugin_unload (PLUGIN_ID_DECAPS);
	plugin_unload (PLUGIN_ID_NAV);
	plugin_unload (PLUGIN_ID_CODEC_AUDIO);
	plugin_unload (PLUGIN_ID_CODEC_VIDEO);
	plugin_unload (PLUGIN_ID_CODEC_SPU);
        
	return 0;
}


/**
 * open video output plugin
 **/

int omsOpenOutputVideo(const char *fourcc_in,
                       const char *fourcc_out, const char *output_path)
{
	return render_video_open (fourcc_out, output_path);
}


/**
 * open video output function 
 **/

int omsOpenOutputVideoFunc (void *func)
{
	return render_video_open_func (func);
}


/**
 * open audio output device
 **/

int omsOpenOutputAudio(const char *fourcc_in,
                       const char *fourcc_out, const char *output_path)
{
        return render_audio_open (fourcc_out, output_path);
}


int omsCloseOutputAudio (void) 
{
	int ret;

	render_audio_close ();
	ret = plugin_unload (PLUGIN_ID_OUTPUT_AUDIO);

	if (ret < 0)
                LOG (LOG_ERROR, "couldn't close Output Audio Plugin");

	return ret;
}


int omsCloseOutputVideo (void) 
{
	int ret;

	render_video_close ();
	ret = plugin_unload (PLUGIN_ID_OUTPUT_VIDEO);

	if (ret < 0)
                LOG (LOG_ERROR, "couldn't close Output Video Plugin");

	return ret;
}


/**
 * clean all we've messed around during outputting). ok - frankly speaking,
 * this still needs a little bit of work.
 **/

int omsCloseOutput (void)
{
	int ret = 0;

	ret |= omsCloseOutputVideo ();
        ret |= omsCloseOutputAudio ();
        
	return ret;
}


nav_tree_t *omsGetInfo (uint id)
{
	plugin_nav_t *plugin_nav = plugin_get_active_ops (PLUGIN_ID_NAV);

	if (plugin_nav) 
		return plugin_nav->get_info (id);
        
	return NULL;
}


/**
 * OMS set status
 **/

static int set_status_play (void) 
{
	if (oms_thread_demux_is_status (STATUS_STOP)) {
		oms_thread_demux_set_status (STATUS_PLAY);
		oms_thread_input_start (buf);
		oms_thread_demux_start (buf);
	} else {
		oms_thread_demux_set_status (STATUS_PLAY);
		oms_thread_demux_kick ();
	}

	return 0;
}


static int set_status_pause_on (void) 
{
	if (!oms_thread_demux_is_status (STATUS_PLAY))
		return -1;

	oms_thread_demux_set_status (STATUS_PAUSE);

        return 0;
}


static int set_status_pause_off (void) 
{
	if (!oms_thread_demux_is_status (STATUS_PAUSE))
		return -1;
        
	oms_thread_demux_set_status (STATUS_PLAY);
	oms_thread_demux_kick ();

	return 0;
}


static int set_status_stop (void) 
{
	if (oms_thread_demux_is_status (STATUS_STOP))
		return -1;

	oms_thread_demux_set_status (STATUS_STOP);
	oms_thread_input_stop ();
	oms_thread_demux_stop ();
	oms_buf_flush (buf, BUF_ANY);

// FIXME: close open descriptors here  
	return 0;
}


int oms_set_status (int status)
{
	switch (status) {
	case STATUS_PLAY:
		return set_status_play ();

	case STATUS_PAUSE_ON:
		return set_status_pause_on ();
		
	case STATUS_PAUSE_OFF:
		return set_status_pause_off ();
                
	case STATUS_STOP:
		return set_status_stop ();

	default:
		return -1;
	} 

	return 0;
}


/**
 * get internal information of oms status
 **/

int oms_get_status (void)
{
	return oms_thread_demux_get_status ();
}


/**
 * omsSetFilter - set stream filtering
 * @id: stream_id
 * @val: values to set filter to
 **/

int omsSetFilter (uint id, int val)
{
	plugin_decaps_t *plugin_decaps = plugin_get_active_ops (PLUGIN_ID_DECAPS);
       	plugin_codec_t *plugin_codec;

// FIXME: pass an id to the nav structure when getting infos, so we don't have
//	to do this hack here (substracting -1 ... cause -1 means off, and the
//	streams are starting from 0 ... the navstruct starts at 0 :(
	val--;

	switch (id) {
	case BUF_VIDEO:
		plugin_codec = plugin_get_active_ops (PLUGIN_ID_CODEC_VIDEO);

		if (plugin_codec)
		if (plugin_codec->ctrl)
			if (plugin_codec->ctrl (plugin_codec, CTRL_VIDEO_SET_STREAM, val) < 0)
				return -1;
		break;

	case BUF_AUDIO:
		plugin_codec = plugin_get_active_ops (PLUGIN_ID_CODEC_AUDIO);
		current.audio = val;

		if (plugin_decaps)
			if (plugin_decaps->ctrl (plugin_decaps, CTRL_DECAPS_SETFILTER, BUF_AUDIO, val) < 0)
				return -1;

		if (plugin_codec)
		if (plugin_codec->ctrl)
			if (plugin_codec->ctrl (plugin_codec, CTRL_AUDIO_SET_STREAM, val) < 0)
				return -1;
		break;
                
	case BUF_SUBPIC:
		plugin_codec = plugin_get_active_ops (PLUGIN_ID_CODEC_SPU);
		current.subpic = val;

		if (plugin_decaps)
			if (plugin_decaps->ctrl (plugin_decaps, CTRL_DECAPS_SETFILTER, BUF_SUBPIC, val) < 0)
				return -1;

		if (plugin_codec)
		if (plugin_codec->ctrl)
			if (plugin_codec->ctrl (plugin_codec, CTRL_SPU_SET_STREAM, val) < 0)
				return -1;
		break;

	default:
                LOG (LOG_ERROR, "Invalid filter %d", id);
		return -1;
	}

	return 0;
}


/**
 * omsGetFilter - get actual filter settings
 * @id: stream_id
 **/

int omsGetFilter (uint id)
{
	switch (id) {
	case BUF_AUDIO:
		return current.audio;

	case BUF_SUBPIC:
		return current.subpic;	
	}

	return -1;
}


int omsPartPlayAutoStop (int title, int part, int parts2play)
{
	plugin_nav_t *nav = plugin_get_active_ops (PLUGIN_ID_NAV);
        plugin_codec_t *video = plugin_get_active_ops(PLUGIN_ID_CODEC_VIDEO);

        /*
         * FIXME : until mpeg2dec can handle bad stream (and so stream change),
         * we need to re-init the video codec to avoid error.
         */
        oms_set_status(STATUS_PAUSE);
        oms_buf_flush(buf, BUF_ANY);

        /*
         * Make libmpeg2 crash, walken say it's not needed :)
         *
         * video->close(video);
         */
        video->open(video, NULL);
        
	LOG (LOG_DEBUG, "title: %d part: %d parts2play: %d", title, part, parts2play);
	nav->play (title, part, parts2play);

        return oms_set_status (STATUS_PLAY);
}


int omsPartPlay (int title, int part)
{
	LOG (LOG_DEBUG, "title: %d part: %d", title, part);
	return omsPartPlayAutoStop (title, part, 0);
}


int omsTitlePlay (int title)
{
	LOG (LOG_DEBUG, "title: %d", title);
	return omsPartPlayAutoStop (title, 0, 0);
}


int omsPlay (void)
{
	LOG (LOG_DEBUG, " ");
	return omsPartPlayAutoStop (0, 0, 0);
}


