
/*
 *
 * Copyright (C) 2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#include <string.h>

#include <oms/oms.h>
#include <oms/log.h>

#if 0
typedef struct {
	char cmd[80];
	char format[20];
	int (*fkt) ();
} oms_cmd_t;

static oms_cmd_t cmd_list[] = {
	{"init", "", oms_init},
	{"open_input", "%s", omsOpenInput},
	{"close_input", "", omsCloseInput},
	{"open_output_audio", "%s%s%s", omsOpenOutputAudio},
	{"close_output_audio", "", omsCloseOutputAudio},
	{"open_output_video", "%s%s%s", omsOpenOutputVideo},
	{"close_output_video", "", omsCloseOutputVideo},
	{"close_output", "", omsCloseOutput},
	{"set_status", "%d", oms_set_status},
	{"get_status", "", oms_get_status},
	{"set_filter", "%d%d", omsSetFilter},
	{"get_filter", "%d", omsGetFilter},
	{"", "", NULL}
};

static int _oms_exec_cmd ()
{
	return 0;
}

int oms_cmd (char *cmd, ...)
{
	va_list arg_list;
	oms_cmd_t *cmd_ptr = cmd_list;

	va_start (arg_list, cmd);

	LOG (LOG_INFO, "executing command: %s\n", cmd);

	while (cmd_ptr->fkt) {
		if (!strcasecmp (cmd, cmd_ptr->cmd))
			return 0;
//                      return cmd_ptr->fkt (arg_list);

		cmd_ptr++;
	}

	return -2;
}
#endif
