/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include <stdio.h>
#include <config.h>
#include <oms/oms.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

int main (void)
{
	int plugin_type;

	plugin_mgr_init ();

	fprintf (stderr, "scanning plugindir: %s\n", PLUGIN_DIR);
	plugin_mgr_scandir (PLUGIN_DIR);

	for (plugin_type = 0; plugin_type < MAX_PLUGIN_ID; plugin_type++) {	// loop plugin types
		plugin_entry_t *entry = plugin_get_registered (plugin_type);

		printf ("<plugin_id=%d>\n", plugin_type);
		while (entry) {
			printf ("\t<plugin>\n");
			printf ("\t\tname=\"%s\"\n", entry->whoami);
			printf ("\t\tdepend=\"%s\"\n",
				entry->depend ? "yes" : "no");
			printf ("\t\tfourcc_in=\"%s\"\n",
				entry->fourcc_in ? (char *) entry->
				fourcc_in : "[null]");
			printf ("\t\tfourcc_out=\"%s\"\n",
				entry->fourcc_out ? (char *) entry->
				fourcc_out : "[null]");
			printf ("\t</plugin>\n");

			entry = entry->next;
		}
		printf ("</plugin_id=%d>\n", plugin_type);
	}

	plugin_mgr_exit ();

	return 0;
}
