/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include <pthread.h>
#include <sys/time.h>

#include <oms/oms.h>
#include <oms/plugin.h>
#include <oms/plugin/decaps.h>
#include <oms/buf.h>
#include <oms/log.h>

#include "thread_input.h"

static struct {
	pthread_mutex_t mutex;
	pthread_cond_t cond;
	pthread_t thread;
} ctrl;


static void *_oms_thread_input (void *_buf)
{
        plugin_decaps_t *plugin_decaps = plugin_get_active_ops (PLUGIN_ID_DECAPS);
	buf_t *buf = (buf_t *) _buf;

        while (1) {
                while (!oms_buf_isfull (buf)) {
                        if (plugin_decaps->decaps (buf) < 0) {
                                LOG (LOG_INFO, "no more data left on input");
                                while (!oms_buf_isempty (buf))
                                        usleep (500);
                                
                                oms_set_status(STATUS_STOP);
                                pthread_exit (NULL);
                        }
                }

                pthread_mutex_lock(&ctrl.mutex);
                while ( oms_buf_isfull(buf) ) 
                        pthread_cond_wait(&ctrl.cond, &ctrl.mutex);
                pthread_mutex_unlock(&ctrl.mutex);
        };

        pthread_exit (NULL);
}

void oms_thread_input_start (buf_t *buf)
{
        //demux_set_status (&priv->plugin, STATUS_PLAY);

        pthread_mutex_init (&ctrl.mutex, NULL);
        pthread_cond_init (&ctrl.cond, NULL);
        pthread_create (&ctrl.thread, NULL, _oms_thread_input, buf);
}

void oms_thread_input_stop (void)
{
// FIXME:       pthread_cond_destroy
        pthread_cancel (ctrl.thread);
}

void oms_thread_input_kick (void)
{
        pthread_mutex_lock(&ctrl.mutex);
	pthread_cond_signal(&ctrl.cond);
        pthread_mutex_unlock(&ctrl.mutex);
}




