/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/


//PLUGIN_INFO(INFO_NAME, "MPG123 decoder");

#include <stdlib.h>

#include <oms/oms.h>
#include <oms/plugin/codec.h>
#include <oms/plugin/output_audio.h>

#include "mpg123.h"
#include "mpglib.h"

static int _mpg123dec_open	(void *plugin, void *foo);
static int _mpg123dec_close	(void *plugin);
static int _mpg123dec_read	(void *plugin, buf_t *buf, buf_entry_t *buf_entry);
static int _mpg123_ctrl		(void *plugin, uint flag, ...);

static plugin_codec_t codec_mpg123dec = {
	open:		_mpg123dec_open,
	close:		_mpg123dec_close,
	read:		_mpg123dec_read,
	ctrl:		_mpg123_ctrl,
        config:         NULL,
};

typedef struct {
	int16_t out[16384];
	struct mpstr mp;
	int sample_rate;
	int stereo;
	uint32_t is_output_initialized;
} mpg123_priv_t;


static int _mpg123dec_open (void *plugin, void *foo)
{
	mpg123_priv_t *priv;

	priv = ((plugin_codec_t *) plugin)->priv = calloc (sizeof (mpg123_priv_t), 1);
	InitMP3 (&priv->mp);

	return 0;
}


static int _mpg123dec_close (void *plugin)
{
	mpg123_priv_t *priv = ((plugin_codec_t *) plugin)->priv;

	if (priv)
		free (priv);

	return 0;
}


static int _mpg123dec_read (void *plugin, buf_t *buf, buf_entry_t *buf_entry)
{
	mpg123_priv_t *priv = ((plugin_codec_t *) plugin)->priv;
	int ret;
	uint size;

	ret = decodeMP3 (&priv->mp, buf_entry->data, buf_entry->data_len, (char *) priv->out, 8192, &size);
	
	if((priv->mp.fr.stereo != priv->stereo || priv->mp.fr.sampling_frequency != priv->sample_rate) && ret == MP3_OK) {
		plugin_output_audio_attr_t attr;
#ifdef __sun__
		attr.format = 16;
#else
		attr.format = AFMT_S16_NE;
#endif
		attr.speed = freqs[priv->mp.fr.sampling_frequency];
		priv->sample_rate = priv->mp.fr.sampling_frequency;
		attr.channels = priv->stereo = priv->mp.fr.stereo;

		((plugin_output_audio_t *)((plugin_codec_t *) plugin)->output)->setup (&attr);

		priv->is_output_initialized = 1;
	}

	while (ret == MP3_OK) {
		((plugin_output_audio_t *) codec_mpg123dec.output)->write (priv->out, size);

		ret = decodeMP3 (&priv->mp, NULL, 0, (char *) priv->out, 16384, &size);
	}

	return ret;
}


static int _mpg123_ctrl (void *plugin, uint flag, ...)
{
	mpg123_priv_t *priv = ((plugin_codec_t *) plugin)->priv;

        switch (flag) {
        case CTRL_RESET:
		priv->is_output_initialized = 0;
                break;
        default:
                return -1;
        }

        return 0;
}


int plugin_init (char *whoami)
{
	pluginRegister (whoami,
		PLUGIN_ID_CODEC_AUDIO,
		"mpg1",
		NULL,
		NULL,
		&codec_mpg123dec);

        return 0;
}


void plugin_exit (void)
{
}
