/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

//PLUGIN_INFO(INFO_NAME, "LPCM decoder");
//PLUGIN_INFO(INFO_AUTHOR, "Thomas Mirlacher <dent@linuxvideo.org>");

#include <inttypes.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <oms/oms.h>
#include <oms/plugin/codec.h>
#include <oms/plugin/output_audio.h>

static int _pcmdec_open (void *this, void *output_audio);
static int _pcmdec_close (void *this);
static int _pcmdec_read_uninit (void *this, buf_t *buf, buf_entry_t *buf_entry);
//static int _pcmdec_read_1 (void *this, buf_t *buf, buf_entry_t *buf_entry);
static int _pcmdec_read_2 (void *this, buf_t *buf, buf_entry_t *buf_entry);

static plugin_codec_t codec_pcmdec = {
	open:		_pcmdec_open,
	close:		_pcmdec_close,
	read:		_pcmdec_read_uninit,
        config:         NULL,
};


static int resample_factor;

static int _pcmdec_open (void *this, void *output_audio)
{
	codec_pcmdec.output = output_audio;
	return 0;
}


static int _pcmdec_close (void *this)
{
	return 0;
}


static int _pcmdec_read_uninit (void *this, buf_t *buf, buf_entry_t *buf_entry)
{
	plugin_codec_t *plugin = (plugin_codec_t *) this;
	plugin_output_audio_attr_t attr;

#ifdef __sun__
	attr.format = 16;
#else
	attr.format = AFMT_S16_NE;
#endif
	attr.speed = 24000;
	attr.channels = 2;

	if (!((plugin_output_audio_t *)codec_pcmdec.output)->setup (&attr)) {
		plugin->read = _pcmdec_read_2;
	} else {		// try downsampling 2:1
		resample_factor = 2;
		attr.speed /= resample_factor;

		if (!((plugin_output_audio_t *)codec_pcmdec.output)->setup (&attr))
			plugin->read = _pcmdec_read_2;
		else
			return -1;
	}

	plugin->read (this, buf, buf_entry);

	return 0;
}

#if 0
static int _pcmdec_read_1 (void *this, buf_t *buf, buf_entry_t *buf_entry)
{
	((plugin_output_audio_t *) codec_pcmdec.output)->write (buf_entry->data, buf_entry->data_len);

	return 0;	
}
#endif

static int _pcmdec_read_2 (void *this, buf_t *buf, buf_entry_t *buf_entry)
{
	int i = 0;
	int o = 0;
	uint8_t *src = buf_entry->data;
	uint8_t *dst = buf_entry->data;
	plugin_output_audio_t *output = codec_pcmdec.output;

// FIXME: what about using sint16_t ?

	if (resample_factor > 1)
		for (i=0, o=0; i<buf_entry->data_len; i+=resample_factor, o+=1)
			dst[o] = src[i];

	output->write ((void *) dst, o);

	return 0;	
}


int plugin_init (char *whoami)
{
	pluginRegister (whoami,
		PLUGIN_ID_CODEC_AUDIO,
		"pcm",
		NULL,
		NULL,
		&codec_pcmdec);

	return 0;
}


void plugin_exit (void)
{
}

