/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __SPU_H__
#define __SPU_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

struct spu_img_struct {
	u_char *data;		// 7-4: mixer key, 3-0: color index
	u_int x;		// x start of subpicture area
	u_int y;		// y start of subpicture area
	int width;		// width of subpicture area
	int height;		// height of subpicture area

// DENT: this is just a clut_index_table, but we also like to save out personal  clut here ...
	u_char clut_index[4];		// color lookup table
	u_char trans[4];	// mixer key table

// DENT: also need to have active areas here (for menu stuff - set by nav-pkts)
	u_int time_execute;	// time in ms

	clut_t *clut;           // YUV-CLUT

// private stuff
	u_int	_x;		// current destination x, y
	u_int	_y;
	u_int	offset[2];	// address in PXD to fetch next rle-code from, one per field
};


typedef struct spu_clut_struct {
#ifdef WORDS_BIGENDIAN
	uint8_t	entry0	: 4;
	uint8_t	entry1	: 4;
	uint8_t	entry2	: 4;
	uint8_t	entry3	: 4;
#else
	uint8_t	entry1	: 4;
	uint8_t	entry0	: 4;
	uint8_t	entry3	: 4;
	uint8_t	entry2	: 4;
#endif
} spu_clut_t;


void spuInit (void);
void decode_spu (u_char *data_start, u_char *data_end);
u_int buffer_spupack (u_int *length, u_char **start, u_char *end);
int spuParseHdr (struct spu_img_struct *spu, u_char *pkt_data, u_int pkt_len);
void spuParseData (struct spu_img_struct *spu);

#endif
