
/*
 * AUDIO VIDEO PES DECAPSULATION 
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <inttypes.h>
#include <sys/stat.h>
#include <netinet/in.h>

#include <dvb/ps.h>
#include <dvb/pes.h>
#include <dvb/avp.h>
#include <oms/oms.h>
#include <oms/plugin/decaps.h>

static int _avp_open (void *self, void *name);
static int _avp_close (void *self);
static int _avp_decaps (buf_t * buf);
static int _avp_ctrl (void *self, uint ctrl_id, ...);

static struct avp_priv_struct {
	uint filter[_BUF_MAX];
} priv;

static char avp_file_magic[] = {
	'A', 'V'
};

static plugin_decaps_magic_t _avp_magic = {
	"avp",
	2,
	avp_file_magic
};

static plugin_decaps_t decaps = {
	priv:&priv,
	open:_avp_open,
	close:_avp_close,
	decaps:_avp_decaps,
	ctrl:_avp_ctrl,
	magic:&_avp_magic,
	blocksize:2048,
	config:NULL,
};

static buf_t *buf;
static buf_entry_t *buf_entry = NULL;

#define AUDIO_LPCM	0xA0
#define AUDIO_AC3	0x80
#define SPU_SUBTITLE	0x20

#define PS_FILTER_VIDEO 0xE0
#define PS_FILTER_SPU   0x20

static int _avp_open (void *self, void *name)
{
	LOG (LOG_DEBUG, "decaps_init called\n");

//DENT just for debugging purposes
	priv.filter[BUF_VIDEO] = 0xE0;
	priv.filter[BUF_SUBPIC] = -1;	// subtitle substream id (0..31,-1=off)
	priv.filter[BUF_AUDIO] = 0x00;	// audio substream id (0...7, -1=off)

	return 0;
}

static int _avp_close (void *self)
{
	return 0;
}

#if 0
static inline char *_get_bytes_block (uint len)
{
	if (!buf_entry)
		if (!(buf_entry = oms_buf_alloc (buf, decaps.blocksize)))
			return NULL;

	if (decaps.read (buf, buf_entry) <= 0)
		return NULL;

	buf_entry->data = buf_entry->mem + len;

	return buf_entry->mem;
}
#else
#define _get_bytes_block _get_bytes
#endif

static inline char *_get_bytes (uint len)
{
#if 0
	if (buf_entry->mem) {
		free (buf_entry->mem)
		    buf_entry->mem = malloc (len);	// check return val
	}

	if (decaps.read (buf_entry->mem, len) <= 0)
		return NULL;

	return buf_entry->mem;
#else
	char *ptr = buf_entry->data;

	buf_entry->data += len;

	return ptr;
#endif
}

static int _avp_decaps (buf_t * _buf)
{
	avp_hdr_t *avp;

	buf = _buf;

	if (!(avp = (avp_hdr_t *) _get_bytes_block (AVP_HDR_LEN)))
		return -1;

	buf_entry->flags =
	    avp->pts_present ? BUF_FLAG_PTS_VALID : BUF_FLAG_NONE;

	switch (avp->stream_id) {
	case AVP_VIDEO:
		buf_entry->buf_id = BUF_VIDEO;
		LOG (LOG_DEBUG, "AVP: video\n");
		break;
	case AVP_AUDIO:
		buf_entry->buf_id = BUF_AUDIO;
		LOG (LOG_DEBUG, "AVP: audio\n");
		break;
	default:
		LOG (LOG_DEBUG, "AVP: unhandled AVP id 0x%02x\n",
		     avp->stream_id);
	}

	LOG (LOG_DEBUG, "AVP: len: %d",
	     avp->length_hi << 8 | avp->length_lo);

	//_get_bytes (avp->length_hi<<8 | avp->length_lo);
	LOG (LOG_DEBUG, "AVP: fix me !!!\n");

// parse prefix and rest of hdr here
	return 0;
}

static int _avp_ctrl (void *self, uint ctrl_id, ...)
{
	va_list arg_list;

	LOG (LOG_DEBUG, "ctrl_id: 0x%x", ctrl_id);

	va_start (arg_list, ctrl_id);

	switch (ctrl_id) {
	case CTRL_DECAPS_SETFILTER:{
			int filter_id = va_arg (arg_list, int);
			uint32_t val = va_arg (arg_list, uint32_t);

			if (filter_id > _BUF_MAX)
				return -1;

			priv.filter[filter_id] = val;
			break;
		}

	default:
		va_end (arg_list);
		return -1;
	}

	va_end (arg_list);
	return 0;
}

int PLUGIN_INIT (decaps_avp) (char *whoami) {
	pluginRegister (whoami,
			PLUGIN_ID_DECAPS, "avp", "es", NULL, &decaps);

	return 0;
}

void PLUGIN_EXIT (decaps_avp) (void) {
	LOG (LOG_DEBUG, "decaps_close called\n");
}
