
/*
 * DUMMY DECAPSULATION
 *
 * Copyright (C) 2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <inttypes.h>
#include <sys/stat.h>
#include <netinet/in.h>

#include <oms/oms.h>
#include <oms/log.h>
#include <oms/plugin/decaps.h>

static int _dummy_open (void *self, void *name);
static int _dummy_close (void *self);
static int _dummy_decaps (buf_t * buf);
static int _dummy_ctrl (void *self, uint ctrl_id, ...);

static plugin_decaps_magic_t _dummy_magic = {
	"mp3",
	0,
	NULL
};

//mp3: ff fb

static plugin_decaps_t decaps = {
	open:_dummy_open,
	close:_dummy_close,
	decaps:_dummy_decaps,
	ctrl:_dummy_ctrl,
	magic:&_dummy_magic,
	blocksize:2048,
	config:NULL,
};

static int _dummy_open (void *self, void *name)
{
	return 0;
}

static int _dummy_close (void *self)
{
	return 0;
}

static int _dummy_decaps (buf_t * buf)
{
	static buf_entry_t *buf_entry = NULL;

	if (!(buf_entry = oms_buf_alloc (buf, decaps.blocksize)))
		return 0;

	if (
	    (buf_entry->mem_len =
	     decaps.read (NULL, buf_entry->mem, buf_entry->mem_len)) > 0) {
		buf_entry->flags = BUF_FLAG_NONE;
		buf_entry->buf_id = BUF_AUDIO;
		buf_entry->type = FOURCC_MP3;

		decaps.write (buf, buf_entry);
	} else {
		return -1;
	}

	return 0;
}

static int _dummy_ctrl (void *self, uint ctrl_id, ...)
{
	LOG (LOG_DEBUG, "no ctrl available");
	return -1;
}

int PLUGIN_INIT (decaps_dummy) (char *whoami) {
	pluginRegister (whoami,
			PLUGIN_ID_DECAPS, "null", "*", NULL, &decaps);

	return 0;
}

void PLUGIN_EXIT (decaps_dummy) (void) {
}
