
/*
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
 
#ifndef HAVE_LINUX_RAW_H
int main()
{
	fprintf(stderr,"support for linux raw devices not compiled in.\n");
	exit(EXIT_FAILURE);
}
#else

#include <errno.h>
 
#include "linux_raw.h"
int main (int argc, char *argv[])
{
	int fd_raw;
	char *buf;
#define BUF_COUNT 10   
#define BUF_SIZE 2048
	int i;
   
	if(argc!=2) {
		fprintf(stderr,"Usage: %s <device>\n", argv[0]);
		exit(EXIT_FAILURE);
	}

// allocate buffer
	if(!(buf=valloc(BUF_SIZE))) {
		fprintf(stderr,"could not valloc %d bytes: %s\n",BUF_SIZE,strerror(errno));
		exit(EXIT_FAILURE);
	}

// open raw device
	if((fd_raw = raw_open(argv[1])) < 0) {
		fprintf(stderr,"raw device for `%s': could not be opened\n",argv[1],strerror(errno));
		exit(EXIT_FAILURE);
	}
	fprintf(stderr,"raw device for `%s': successfully opened\n",argv[1]);

// read from raw device
	for (i=0; i!=BUF_COUNT; ++i) {
		if(read(fd_raw,buf,BUF_SIZE)!=BUF_SIZE) {
			fprintf(stderr,"raw device for `%s': could not read %d bytes\n",argv[1],BUF_SIZE);
		exit(EXIT_FAILURE);
		}
		fprintf(stderr,"raw device for `%s': succecssfully read %d bytes\n",argv[1],BUF_SIZE);
	}

// close raw device
	if (raw_close(fd_raw)) {
		fprintf(stderr,"error closing raw device for `%s':
%s\n",argv[1],strerror(errno));
		exit(EXIT_FAILURE);
	}
	fprintf(stderr,"raw device for `%s': successfully closed\n",argv[1]);
   
	exit(EXIT_SUCCESS);
}
#endif
