/*
 *
 * Copyright (C) 2000 Yuqing Deng <Yuqing_Deng@brown.edu>
 *
 * navigation packet structure from vobdump by Eric Smith <eric@brouhaha.com>
 * 
 * program organization and bit stream buffering stolen from extract_ac3.c
 * by Aaron Holtzman <aholtzma@engr.uvir.ca>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *------------------------------------------------------------  
 */

#ifndef __NAV_H__
#define __NAV_H__

typedef struct {
	uint32_t nv_pck_lbn:32;	// logic block number
	uint16_t vobu_cat:16;	// vobu category
	uint16_t reserved:16;
	uint32_t vobu_uop_ctl:32;	// user operation
	uint32_t vobu_s_ptm:32;
	uint32_t vobu_e_ptm:32;
	uint32_t vobu_se_e_ptm:32;
	uint32_t e_eltm:32;	// ? elspe time
	uint8_t vobu_isrc[32];	// information source?
// non seamless angle cell ??? address
	uint32_t nsml_agli_dsta[9];
} nav_pci_gi;

// highlight info

typedef struct {
	uint8_t reserved:8;
	uint8_t hli_ss:2;	// 6 bit reserved, 2 bit hli_ss
	uint8_t reserved0:6;
	uint8_t hli_s_ptm[4];
	uint8_t hli_e_ptm[4];
	uint8_t btn_se_e_ptm[4];

	uint8_t btngr0_dsp_ty:3;
	uint8_t reserved2:1;
	uint8_t btngr_ns:2;
	uint8_t reserved1:2;

	uint8_t btngr2_dsp_ty:3;
	uint8_t reserved4:1;
	uint8_t btngr1_dsp_ty:3;
	uint8_t reserved3:1;

	uint8_t btn_ofn:8;
	uint8_t btn_ns:6;	// 2 reserved, 6 btn_ns
	uint8_t reserved5:2;
	uint8_t nsl_btn_ns:6;	// 2 reserved, 6 nsl_btn_ns
	uint8_t reserved6:2;
	uint8_t reserved7:8;

	uint8_t fosl_btnn:6;	// 2 reserved, 6 nsl_btn_ns
	uint8_t reserved8:2;

	uint8_t foac_btnn:6;	// 2 reserved, 6 foac_btnn
	uint8_t reserved9:2;

	uint8_t btn_coli_0_sl[4];
	uint8_t btn_coli_0_ac[4];
	uint8_t btn_coli_1_sl[4];
	uint8_t btn_coli_1_ac[4];
	uint8_t btn_coli_2_sl[4];
	uint8_t btn_coli_2_ac[4];
} nav_pci_hli_gi;

typedef struct {
	uint8_t x_start_f6:6;	// first 6 bits of x_start
	uint8_t btn_coln:2;	// 2 button color number
	uint8_t x_end_f2:2;	// first 2 bits of x_end
	uint8_t reserved:2;
	uint8_t x_start_l4:4;	// last 4 bits of x_start
	uint8_t x_end_l8:8;	// last 8 bits of x_end

	uint8_t y_start_f6:6;	// first 6 bits of y_start
	uint8_t auto_action_mode:2;	// 2
	uint8_t y_end_f2:2;	// first 2 bits of y_end
	uint8_t reserved1:2;
	uint8_t y_start_l4:4;	// last 4 bits of y_start
	uint8_t y_end_l8:8;

	uint8_t up:6;		// 6 bits up button number
	uint8_t reserved2:2;
	uint8_t down:6;		// down button number
	uint8_t reserved3:2;
	uint8_t left:6;
	uint8_t reserved4:2;
	uint8_t right:6;
	uint8_t reserved5:2;

	uint8_t btn_command[8];
} nav_pci_btnit;

typedef struct {
	uint32_t nv_pck_scr:32;
	uint32_t nv_pck_lbn:32;	// logic block number
	uint32_t vobu_ea:32;	// vobu category
	uint32_t vobu_1stref_ea:32;
	uint32_t vobu_2ndref_ea:32;
	uint32_t vobu_3rdref_ea:32;
	uint16_t vobu_vob_idn:16;	// vob id
	uint8_t reserved:8;
	uint8_t vobu_c_idn:8;	// cell id
	uint32_t c_eltm:32;	// cell elspe time
} nav_dsi_gi;

int decode_nav (char *data, int size);
#endif
