
/*
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#include <oms/oms.h>
#include <oms/log.h>
#include <oms/plugin/input.h>
#include <oms/plugin/decaps.h>
#include <oms/plugin/nav.h>
#include <oms/plugin/codec.h>

#include "../input/input_file.h"
#include "nav_dvd_pkt.h"

extern int plugin_get_decaps_magic (char *filename);

static int _dvd_buf_validate (buf_t * buf, buf_entry_t * buf_entry);

static int _file_open (void *plugin, void *path);
static int _file_close (void *plugin);
static int _file_PartPlayAutoStop (int title, int chapter, int parts2play);
static nav_tree_t *_file_get_info (uint id);
static int _file_RegisterCb (uint id, oms_callback_t cb, void *data);
static int _file_UnregisterCb (uint id);

static struct {
	char *root;
} file_priv;

static plugin_nav_t file_nav = {
	priv:&file_priv,
	open:_file_open,
	close:_file_close,
	play:_file_PartPlayAutoStop,
	get_info:_file_get_info,
	register_cb:_file_RegisterCb,
	unregister_cb:_file_UnregisterCb,
	config:NULL,
};

static int _file_open (void *plugin, void *path)
{
	plugin_input_t *plugin_input;
	plugin_decaps_t *plugin_decaps;

	file_priv.root = path;

	if (!(plugin_input = pluginLoad (PLUGIN_ID_INPUT, "file", NULL)))
		return -1;

	plugin_input->open (plugin_input, path);

	if (plugin_get_decaps_magic (path) < 0)
		return -1;

	plugin_decaps = plugin_get_active_ops (PLUGIN_ID_DECAPS);
	plugin_input->blocksize = plugin_decaps->blocksize;
	plugin_decaps->read = plugin_input->read;
	plugin_decaps->write = _dvd_buf_validate;	//oms_buf_validate;
	plugin_decaps->open (plugin_decaps, NULL);

	plugin_input->seek (plugin_input, 0);

// video
	{
		plugin_codec_t *plugin_codec_video;

		if (!
		    (plugin_codec_video =
		     pluginLoad (PLUGIN_ID_CODEC_VIDEO, "mpg2", NULL))) {
			LOG (LOG_ERROR,
			     "failed to open video codec plugin");
			return -1;
		}

		plugin_codec_video->open (plugin_codec_video, NULL);
		plugin_codec_video->output =
		    plugin_get_active_ops (PLUGIN_ID_OUTPUT_VIDEO);
	}

// subpicture
	{
		plugin_codec_t *plugin_codec;

		if (!
		    (plugin_codec =
		     pluginLoad (PLUGIN_ID_CODEC_SPU, "spu ", NULL))) {
			LOG (LOG_ERROR, "failed to open spu codec plugin");
			return -1;
		}

		plugin_codec->open (plugin_codec, NULL);
		plugin_codec->output =
		    plugin_get_active_ops (PLUGIN_ID_OUTPUT_VIDEO);
	}

/***** DIRTY parsing right now -
	use a nicer scheme (mimetypes or autodiscovery from buffer)
 *****/

	{
		char *ptr = strrchr ((const char *) path, '.');

		if (!strcasecmp (ptr, ".ps")) {
		} else if (!strcasecmp (ptr, ".mp3") ||
			   !strcasecmp (ptr, ".ts") ||
			   !strcasecmp (ptr, ".mpeg")) {
			if (!pluginLoad
			    (PLUGIN_ID_CODEC_AUDIO, "mpg1",
			     NULL)) goto audio_error;
		} else {
			//!strcasecmp (ptr, ".mpg") ||
			if (!pluginLoad
			    (PLUGIN_ID_CODEC_AUDIO, "ac3 ",
			     NULL)) goto audio_error;
		}
	}

	{
		plugin_codec_t *plugin_codec_audio;

		if (
		    (plugin_codec_audio =
		     plugin_get_active_ops (PLUGIN_ID_CODEC_AUDIO))) {
			plugin_codec_audio->open (plugin_codec_audio,
						  NULL);
			plugin_codec_audio->output =
			    plugin_get_active_ops (PLUGIN_ID_OUTPUT_AUDIO);
		}
	}
	return 0;

      audio_error:
	LOG (LOG_ERROR, "failed to open video codec plugin");
	return -1;
}

static int _file_close (void *plugin)
{
//      _PLUGIN_OPS_CODEC_AUDIO(file_priv.plugin)->close (file_priv.plugin->ops[PLUGIN_ID_CODEC_AUDIO]);
//      _PLUGIN_OPS_CODEC_VIDEO(file_priv.plugin)->close (file_priv.plugin->ops[PLUGIN_ID_CODEC_VIDEO]);
//      return PLUGIN_OPS_INPUT(file_priv.plugin)->close (file_priv.plugin->ops[PLUGIN_ID_INPUT]);
	return 0;
}

static int _file_PartPlayAutoStop (int title, int chapter, int parts2play)
{
//      PLUGIN_OPS_INPUT(file_priv.plugin)->seek (0);

	return 0;
}

static nav_tree_t *_file_get_info (uint id)
{
	nav_tree_t *tree = NULL;

	switch (id) {
	case OMS_INFO_PROGRAM:{
			tree = malloc (sizeof (nav_tree_t));

			tree->num = 1;
			tree->title =
			    malloc (sizeof (nav_subtree_t) * tree->num);

			{
				nav_subtree_t *sub_tree = tree->title;

				sub_tree->sub = (nav_tree_data_t *)
				    malloc (sizeof (nav_tree_data_t));
				sub_tree->num = 0;
				sub_tree->name = strdup (file_priv.root);
			}
			break;
		}
	default:
		LOG (LOG_DEBUG, "unhandled OMS_INFO %s", "tjo");
	}

	return tree;
}

static int _file_RegisterCb (uint id, oms_callback_t cb, void *data)
{
	LOG (LOG_DEBUG, "UI registered callback");

	switch (id) {
	case CB_BUF_DONE:
#if 0

		((file_priv_t
		  *) (PLUGIN_OPS_INPUT (file_priv.plugin)->priv))->
		    callb.chapter = cb;
		((file_priv_t
		  *) (PLUGIN_OPS_INPUT (file_priv.plugin)->priv))->
		    callb.chapter_data = data;
#endif
		break;
	}

	return 0;
}

static int _file_UnregisterCb (uint id)
{
	LOG (LOG_DEBUG, "UI unregistered callback %d", id);

	return 0;
}

/**
 * ok, decapsulator called, and returned something, but we do some pre-checking
 * on the data (probably we need something like DSI stuff)
 **/

static int _dvd_buf_validate (buf_t * buf, buf_entry_t * buf_entry)
{
	if (buf_entry->type == FOURCC_NAV) {
		decode_nav (buf_entry->mem, buf_entry->mem_len);
		return 0;
	}

	return oms_buf_validate (buf, buf_entry);
}

int plugin_init (char *whoami)
{
	pluginRegister (whoami,
			PLUGIN_ID_NAV, "file", NULL, NULL, &file_nav);

	return 0;
}

void plugin_exit (void)
{
}
