//TOAST_SPU will define ALL spu entries - no matter the tranparency
//#define TOAST_SPU

/*
 *
 * Copyright (C) 2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#include <string.h>
#include <stdlib.h>
#include <inttypes.h>

#include <oms/plugin/output_video.h>
#include <oms/log.h>

static uint32_t *index_tbl_x;
static uint32_t *index_tbl_y;
static uint32_t dst_width;
static uint32_t dst_height;
static uint32_t src_width;

#define BPP_T uint16_t
#define BPP 2

#define RESCALE(bpp, img)					\
{								\
	uint ## bpp ## _t *dst = (uint ## bpp ## _t *) img;	\
	uint ## bpp ## _t *src;					\
	uint32_t y = 0;						\
								\
	uint32_t *y_indx = index_tbl_y;				\
	uint32_t *y_end = &index_tbl_y[dst_height];		\
	uint32_t *x_indx;					\
	uint32_t *x_end = &index_tbl_x[dst_width];		\
								\
	while (y_indx < y_end) {				\
		src = (uint ## bpp ##_t *) (img + *y_indx*src_width*bpp);\
		dst = (uint ## bpp ##_t *) (img + y*src_width*bpp);\
		y++;						\
								\
		x_indx = index_tbl_x;				\
		y_indx++;					\
								\
		while (x_indx < x_end) {			\
			*dst++ = *(src + *x_indx++);		\
		}						\
	}							\
}

void rescale (uint8_t * img)
{
	BPP_T *dst = (BPP_T *) img;
	BPP_T *src;
	int y = 0;

	uint32_t *y_indx = index_tbl_y;
	uint32_t *y_end = &index_tbl_y[dst_height];
	uint32_t *x_indx;
	uint32_t *x_end = &index_tbl_x[dst_width];

	while (y_indx < y_end) {	// do y rescaling
		src = (BPP_T *) (img + *y_indx * src_width * BPP);
		dst = (BPP_T *) (img + y * src_width * BPP);
		y++;

		x_indx = index_tbl_x;
		y_indx++;

		while (x_indx < x_end) {	// do x rescaling
			*dst++ = *(src + *x_indx++);
		}
	}
}

#if 0
void rescale_16 (uint8_t * img)
{
	RESCALE (16, img);
}

void rescale_32 (uint8_t * img)
{
	RESCALE (32, img);
}

#endif

static uint32_t *build_tbl (uint32_t * tbl, int dst_size, int src_size)
{
	uint16_t i;

// don't do upscaling right now
	if (dst_size > src_size)
		dst_size = src_size;
// don't do upscaling right now

	if (tbl)
		free (tbl);

	tbl = malloc (dst_size * sizeof (int));

	for (i = 0; i < src_size; i++) {
		tbl[(i * dst_size) / src_size] = i;
	}

	return tbl;
}

void rescale_set_factors (int _dst_width, int _dst_height, int _src_width,
			  int _src_height)
{
	dst_width = _dst_width;
	dst_height = _dst_height;
	src_width = _src_width;

	index_tbl_x = build_tbl (index_tbl_x, _dst_width, _src_width);
	index_tbl_y = build_tbl (index_tbl_y, _dst_height, _src_height);
}

void rescale_init (int bpp, int mode)
{
	switch (bpp) {
	case 32:
//              rescale = rescale_32bpp;
		break;
	case 15:
	case 16:
//              rescale = rescale_16bpp;
		break;
	case 8:
//              rescale = rescale_8bpp;
		break;
	default:
		LOG (LOG_ERROR, "%ibpp not supported by rescale", bpp);
	}
}
