/* 
 *  video_out_null.c
 *
 *	Copyright (C) Aaron Holtzman - June 2000
 *
 *  This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 *	
 *  mpeg2dec is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  mpeg2dec is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include <stdlib.h>
#include <inttypes.h>

#include <oms/plugin/output_video.h>
#include <oms/log.h>

static struct _null_priv_s {

} _null_priv;

static int _null_open		(void *self, void *name);
static int _null_close		(void *self);
static int _null_setup		(plugin_output_video_attr_t *attr);
static int _null_draw_frame	(frame_t *frame);
static int _null_draw_slice	(uint8_t *src[], int slice_num);
static void _null_flip_page	(void);
static int _null_overlay	(overlay_buf_t *overlay_buf, int id);
static void _null_free_image_buffer (frame_t *image);
static frame_t *_null_allocate_image_buffer (int width, int height, uint32_t format);

LIBVIDEO_EXTERN(_null, "null");

static int _null_open (void *self, void *name)
{
	return 0;
}


static int _null_close (void *self)
{
	return 0;
}


static int _null_draw_slice (uint8_t *src[], int slice_num)
{
	return 0;
}


static int _null_draw_frame (frame_t *frame)
{
	return 0;
}


static void _null_flip_page (void)
{
}


static int _null_overlay (overlay_buf_t *overlay_buf, int id)
{
	return 0;
}


static int _null_setup (plugin_output_video_attr_t *attr)
{
	return 0;
}


static frame_t *_null_allocate_image_buffer (int width, int height,
					      uint32_t format)
{
	IMG_ALLOC (width, height, format);
}


static void _null_free_image_buffer (frame_t *frame)
{
	IMG_FREE (frame);
}


int PLUGIN_INIT(vo_null)  (char *whoami)
{
	LOG (LOG_DEBUG, " ");

	pluginRegister (whoami,
		PLUGIN_ID_OUTPUT_VIDEO,
		NULL,
		"null",
		NULL,
		&video_out_null);

	return 0;
}


void PLUGIN_EXIT(vo_null) (void)
{
	LOG (LOG_DEBUG, " ");
}

