
/*
 * DVBLIB STRUCTURES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#ifndef __DVB_STRUCT_H__
#define __DVB_STRUCT_H__

#include <inttypes.h>

#define HILO(x) (x##_hi << 8 | x##_lo)

/********** Service Description **********/

typedef struct {
	char service_type;
	char *provider_name;
	char *service_name;
} dvb_descr_service_t;

struct dvb_sdt_descr_struct;

typedef struct dvb_sdt_descr_struct {
	dvb_descr_service_t *service;
	char *country_avail;		
	struct dvb_sdt_descr_struct *next;
} dvb_sdt_descr_t;

struct dvb_sdt_service_struct;

typedef struct dvb_sdt_service_struct {
	uint32_t service_id;		// Service ID
	dvb_sdt_descr_t *descr;
	struct dvb_sdt_service_struct *next;
} dvb_sdt_service_t;

typedef struct {
	uint32_t version;
	uint32_t ts_id;			// Transport Stream ID
	uint32_t orig_nw_id;		// Original Network ID
	dvb_sdt_service_t *service;
} dvb_sdt_t;

/********** NIT **********/

typedef struct {
	uint32_t ts_id;			// Transport Stream ID
	uint32_t orig_nw_id;		// Original Network ID
	char *name;
	uint32_t freq;			// [Hz]
	float orbit;
	uint8_t west_east;
	char polar[20];
	uint32_t rate;			// [Symbols/s]
	uint8_t fec;
} dvb_nit_t;

/********** PMT **********/

struct dvb_pmt_stream_struct;

typedef struct dvb_pmt_stream_struct {
	uint8_t stream_type;
	uint16_t pid;
//	char *info;
	struct dvb_pmt_stream_struct *next;
} dvb_pmt_stream_t;

struct dvb_pmt_struct;

typedef struct dvb_pmt_struct {
	uint32_t prog_nr;
	uint32_t version;
	uint16_t pcr_pid;
	struct dvb_pmt_stream_struct *stream;
} dvb_pmt_t;	

/********** PAT **********/

struct dvb_pat_prog_struct;

typedef struct dvb_pat_prog_struct {
	uint32_t prog_nr;		// 0x00 -> prog = nit
	uint16_t pid;

	union {
		dvb_nit_t *nit;
		dvb_pmt_t *pmt;
	} prog;

	struct dvb_pat_prog_struct *next;
} dvb_pat_prog_t;

typedef struct {
	uint32_t ts_id;
	uint8_t version;
	struct dvb_pat_prog_struct *prog;
} dvb_pat_t;

#endif
