
/*
 * PROGRAM ASSOCIATION TABLE ROUTINES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>

#include <bswap.h>

#include <dvb/pat.h>
#include <dvb/dvb.h>
#include "dvb.h"

int parse_pat (uint8_t *buf, dvb_pat_t *dvb_pat) 
{
	pat_t *pat = (pat_t *) buf;
	dvb_pat_prog_t *dvb_pat_prog_old = NULL;
	uint32_t sec_len;
	uint32_t num_progs;
	int i;
	uint8_t *ptr = buf;

	if (pat->table_id != TID_PAT) {
		fprintf (stderr, "PAT: wrong TID\n");
		return -1;
	}

	sec_len = HILO (pat->section_length);

	if (sec_len < (PAT_LEN + PAT_PROG_LEN))	// min 1 prog in PAT
		return -1;

	dvb_pat->ts_id = bswap_16 (pat->transport_stream_id);
	dvb_pat->version = pat->version_number;

	num_progs = (sec_len - PAT_LEN - 4) / PAT_PROG_LEN;	// 4 CRC_LEN
	ptr += PAT_LEN;

	for (i=0; i<num_progs; i++) {
		pat_prog_t *pat_prog = (pat_prog_t *) ptr;
		dvb_pat_prog_t *dvb_pat_prog = calloc (1, sizeof (dvb_pat_prog_t));
		uint32_t prog_num;
		uint32_t pid;

		prog_num = bswap_16 (pat_prog->program_number);
		pid = HILO (pat_prog->network_pid);

		dvb_pat_prog->prog_nr = prog_num;
		dvb_pat_prog->pid = pid;
//fprintf(stderr,"PAT: 0x%x:0x%x\n", pid, prog_num);
		if (dvb_pat_prog_old)
			dvb_pat_prog_old->next = dvb_pat_prog;
		else
			dvb_pat->prog = dvb_pat_prog;

		dvb_pat_prog_old = dvb_pat_prog;

		ptr += PAT_PROG_LEN;
	}

	return 0;
}
