/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef DVD_UDF_H
#define DVD_UDF_H

#include <inttypes.h>

#define DVD_UDF_VERSION 19991115

/******************************************************************************/
/* The length of one Logical Block of a DVD Video                             */
/******************************************************************************/
#define DVD_VIDEO_LB_LEN 2048

/******************************************************************************/
/* reads Logical Block of the disc or image                                   */
/*   lb_number: disc-absolute logical block number                            */
/*   block_count: number of 2048 byte blocks to read                          */
/*   data: pointer to enough allocated memory                                 */
/*   returns number of read bytes on success, 0 on error                      */
/******************************************************************************/
int UDFReadLB (off_t lb_number, size_t block_count, uint8_t *data);

/******************************************************************************/
/* looks for a file on the UDF disc/imagefile                                 */
/*   filename: absolute pathname on the UDF filesystem, starting with '/'     */
/*   returns absolute LB number, or 0 on error                                */
/******************************************************************************/
unsigned long int UDFFindFile(char *filename);

/******************************************************************************/
/* opens block device or image file                                           */
/*   filename: path to the DVD ROM block device or to the image file          *//*             in UDF format                                                  */
/*   returns fileno() of the file on success, or -1 on error                  */
/******************************************************************************/
int UDFOpenDisc(char *filename);

#endif /* DVD_UDF_H */
